<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="theme-color" content="#000000">
    <title>{{ env('APP_NAME') }}</title>
    <link rel="icon" type="image/png" href="{{ url('app') }}/assets/img/favicon.png" sizes="32x32">
    <link rel="apple-touch-icon" sizes="180x180" href="{{ url('app') }}/assets/img/icon/192x192.png">
    <link rel="stylesheet" href="{{ url('app') }}/assets/css/style.css">
    <link rel="manifest" href="{{ url('app') }}/__manifest.json">
</head>

<body class="bg-white">

    <div id="loader">
        <div class="spinner-border text-primary" role="status"></div>
    </div>
    {{ $slot }}
    <script src="{{ url('app') }}/assets/js/lib/jquery-3.4.1.min.js"></script>
    <!-- Bootstrap-->
    <script src="{{ url('app') }}/assets/js/lib/popper.min.js"></script>
    <script src="{{ url('app') }}/assets/js/lib/bootstrap.min.js"></script>
    <!-- Ionicons -->
    <script type="module" src="https://unpkg.com/ionicons@5.2.3/dist/ionicons/ionicons.js"></script>
    <!-- Owl Carousel -->
    <script src="{{ url('app') }}/assets/js/plugins/owl-carousel/owl.carousel.min.js"></script>
    <!-- jQuery Circle Progress -->
    <script src="{{ url('app') }}/assets/js/plugins/jquery-circle-progress/circle-progress.min.js"></script>
    <!-- Base Js File -->
    <script src="{{ url('app') }}/assets/js/base.js"></script>


</body>

</html>
