<x-guest-layout>
    <div id="appCapsule" style="display: flex; flex-direction: row; justify-content: center; align-items: center; width: 100vw;
    height: 100vh;">
        <div class="login-form mt-10">
            <x-auth-validation-errors class="mb-4" :errors="$errors" />
            <div class="section">
                <img src="{{ url('adm') }}/assets/media/logos/logo.png" alt="image" class="form-image">
            </div>
            <div class="section mt-1 mb-5">
                <form class="form w-100" method="POST" action="{{ route('register') }}">
                    @csrf
                    <div class="form-group boxed">
                        <div class="input-wrapper">
                            <x-input id="name" class="form-control form-control-lg form-control-solid" type="text" name="loja_maconica" :value="old('loja_maconica')" required autofocus placeholder="Loja Maçônica"/>
                            <i class="clear-input">
                                <ion-icon name="close-circle"></ion-icon>
                            </i>
                        </div>
                    </div>
                    <div class="form-group boxed">
                        <div class="input-wrapper">
                            <x-input id="name" class="form-control form-control-lg form-control-solid" type="name" name="name" :value="old('name')" required autofocus placeholder="Nome Completo"/>
                            <i class="clear-input">
                                <ion-icon name="close-circle"></ion-icon>
                            </i>
                        </div>
                    </div>
                    <div class="form-group boxed">
                        <div class="input-wrapper">
                            <x-input id="email" class="form-control form-control-lg form-control-solid" type="email" name="email" :value="old('email')" required autofocus placeholder="Email"/>
                            <i class="clear-input">
                                <ion-icon name="close-circle"></ion-icon>
                            </i>
                        </div>
                    </div>
                    <div class="form-group boxed">
                        <div class="input-wrapper">
                            <x-input id="password" class="form-control form-control-lg form-control-solid"
                                type="password" name="password" required autocomplete="current-password"
                                placeholder="Senha" />

                            <i class="clear-input">
                                <ion-icon name="close-circle"></ion-icon>
                            </i>
                        </div>
                    </div>
                    <div class="form-group boxed">
                        <div class="input-wrapper">
                            <x-input id="password_confirmation" class="form-control form-control-lg form-control-solid" type="password" name="password_confirmation" required autocomplete="current-password" placeholder="Confirme a Senha" />
                            <i class="clear-input">
                                <ion-icon name="close-circle"></ion-icon>
                            </i>
                        </div>
                    </div>
                    <div class=" mt-1 text-left">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" id="aceito" name="aceito">
                            <label class="custom-control-label text-muted" for="aceito">Aceito e/ou Autorizo a divulgação <a href="javascript:;" data-toggle="modal" data-target="#ModalBasic">Termos e Condições de Uso</a></label>
                        </div>
                    </div>
                    <div class="form-group boxed">
                        <div class="input-wrapper">
                            <button id="logar" type="submit" class="btn btn-primary btn-block btn-lg">Cadastrar</button>
                            <button id="carregando" class="btn btn-lg btn-primary w-100 mb-5" disabled>
                                <span class="spinner-border spinner-border-sm align-middle ms-2"></span> Carregando seu perfil...
                             </button>
                        </div>
                    </div>
                    <div class="form-links mt-2">
                        <div><a href="{{ route('login') }}" class="text-muted">Voltar e logar</a></div>
                    </div>
                    <div class="form-button-group"></div>
                </form>
            </div>
        </div>
        <div class="modal fade modalbox" id="ModalBasic" data-backdrop="static" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Termos de uso</h5>
                        <a href="javascript:;" data-dismiss="modal">fechar</a>
                    </div>
                    <div class="modal-body">
                        <p style="text-align: justify;">
                            AUTORIZAÇÃO
                            Em observância à Lei nº. 13.709/18 - LGPD - Lei Geral de Proteção de Dados Pessoais e demais normativas aplicáveis sobre proteção de dados pessoais, manifesto-me de forma livre, expressa e consciente, no sentido de autorizar o Chibarro Grei a realizar o tratamento de meus dados particulares/profissionais para divulgação em aplicativo; assim como sua comunicação através de email, telefone, SMS, aplicativos de mensagens e outros meios digitais.
                        </p>

                    </div>
                </div>
            </div>
        </div>
    </div>
</x-guest-layout>
<script>
    $(document).ready(function() {
        $("#carregando").hide();
        $("#logar").hide();
        $("#logar").click(function() {
            $("#logar").hide();
            $("#carregando").show();
        });

        $("#aceito").change(function(){
            let checkbox = document.getElementById('aceito');
            if(checkbox.checked) {
                $("#logar").show();
            } else {
                $("#logar").hide();
            }
        });



    });
</script>
