@extends('app.base')
@section('content')
    <div class="appHeader bg-primary text-light">
        <div class="left">
            <a href="#" class="headerButton" data-toggle="modal" data-target="#sidebarPanel">
                <ion-icon name="menu-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
            <img src="{{ url('app/assets/img/logo.png') }}" width="200">
        </div>
        <div class="right">
            <a href="{{ route('app.anunciar') }}" class="headerButton">
                <ion-icon name="add-circle"></ion-icon>
            </a>
        </div>
    </div>
    <!-- App Capsule -->
    <div id="appCapsule">

        <div class="section mt-2">
            <div class="profile-head">
                <form id="formSelf" action="{{route('update.foto')}}" method="post" enctype="multipart/form-data">
                    @csrf
                <input type="hidden" name="user_id" value="{{Auth::user()->id}}">
                    <div class="avatar">
                        <div id="carregando_self" class="spinner-grow text-primary" role="status"></div>
                        <label for="self" id="label_self">
                            @if (!empty(Auth::user()->foto))
                                <img class="img_self" src="{{url("storage/".Auth::user()->foto."")}}" style="width: 75px; height: 75px; object-fit: cover; object-position: center;
                                border-radius: 50%;" class="imaged rounded">
                            @else
                            <svg width="75" aria-hidden="true" focusable="false" data-prefix="fas"
                                data-icon="user-circle" class="svg-inline--fa fa-user-circle fa-w-16" role="img"
                                xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512">
                                <path fill="currentColor"
                                    d="M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm0 96c48.6 0 88 39.4 88 88s-39.4 88-88 88-88-39.4-88-88 39.4-88 88-88zm0 344c-58.7 0-111.3-26.6-146.5-68.2 18.8-35.4 55.6-59.8 98.5-59.8 2.4 0 4.8.4 7.1 1.1 13 4.2 26.6 6.9 40.9 6.9 14.3 0 28-2.7 40.9-6.9 2.3-.7 4.7-1.1 7.1-1.1 42.9 0 79.7 24.4 98.5 59.8C359.3 421.4 306.7 448 248 448z">
                                </path>
                            </svg>
                            @endif
                        </label>
                    </div>
                <input class="self" type="file" id="self" name="foto" style="display: none;">
                </form>
                <div class="in">
                    <h3 class="name">{{ Auth::user()->name }}</h3>
                    <h5 class="subtext">{{ Auth::user()->fundador == 1 ? 'Fundador' : 'Anúnciante' }}</h5>
                </div>
            </div>
        </div>

        {{-- <div class="section full mt-2">
            <div class="profile-stats pl-2 pr-2">
                <a href="#" class="item">
                    <strong>152</strong>Anúncios
                </a>
                <a href="#" class="item">
                    <strong>152</strong>Favoritos
                </a>
                <a href="#" class="item">
                    <strong>27k</strong>followers
                </a>
                <a href="#" class="item">
                    <strong>506</strong>following
                </a>
            </div>
        </div> --}}

        <div class="section mt-1 mb-2">
            <div class="profile-info">
                <div class=" bio">
                    {{Auth::user()->perfil}}
                </div>
            </div>
        </div>

        <div class="section full">
            <div class="wide-block transparent p-0">
                <ul class="nav nav-tabs lined iconed" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="tab" href="#anuncios" role="tab">
                            <ion-icon name="grid-outline"></ion-icon>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="tab" href="#friends" role="tab">
                            <ion-icon name="heart-outline"></ion-icon>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="tab" href="#settings" role="tab">
                            <ion-icon name="person-outline"></ion-icon>
                        </a>
                    </li>
                </ul>
            </div>
        </div>

        <!-- tab content -->
        <div class="section full mb-2">
            <div class="tab-content">
                <!-- feed -->
                <div class="tab-pane fade show active" id="anuncios" role="tabpanel">
                    <div class="mt-2">
                        <div class="section-title">Meus Anúncios</div>
                        <ul class="listview image-listview media search-result mb-2" id="result">
                            @foreach ($anuncios as $anuncio)
                             <li>
                                 <a href="#" onclick="javascript:window.open('{{route('app.anuncio',$anuncio->id)}}', '_self')"  class="item">
                                     <div class="imageWrapper">
                                         <img src="{{!empty($anuncio->thumb) ? url("storage/{$anuncio->thumb}") : url('app/assets/img/anuncio.jpg')}}" class="imaged corta-img">
                                     </div>
                                     <div class="in">
                                         <div>
                                             <h4 style="margin-top: -20px;" class="mb-05">{{lmWord($anuncio->empresa, 30)}}</h4>
                                             <div class="text-muted">
                                                 {{@$anuncio->categoria->titulo}} {{!empty($anuncio->sub->titulo) ? '- '.@$anuncio->sub->titulo : ''}}<br>
                                                 <div class="mt-05"><strong>Publicado em: {{ date('d/m/Y', strtotime($anuncio->created_at))}}</strong></div>
                                             </div>
                                             <span class="badge badge-{{ $cor[$anuncio->status] }}">{{ $status[$anuncio->status] }}</span>
                                         </div>
                                     </div>
                                 </a>
                             </li>
                            @endforeach
                         </ul>
                    </div>
                </div>
                <!-- * feed -->

                <!-- * friends -->
                <div class="tab-pane fade" id="friends" role="tabpanel">
                    <div class="mt-2">
                        <div class="section-title">Anúncios Favoritos</div>
                        <ul class="listview image-listview media search-result mb-2" id="result">
                            @foreach ($favoritos as $favorito)
                             <li>
                                 <a href="#" onclick="javascript:window.open('{{route('app.anuncio',$favorito->anuncio->id)}}', '_self')"  class="item">
                                     <div class="imageWrapper">
                                         <img src="{{!empty($favorito->anuncio->thumb) ? url("storage/{$favorito->anuncio->thumb}") : url('app/assets/img/anuncio.jpg')}}" class="imaged corta-img">
                                     </div>
                                     <div class="in">
                                         <div>
                                             <h4 style="margin-top: -20px;" class="mb-05">{{lmWord($favorito->anuncio->empresa, 30)}}</h4>
                                             <div class="text-muted">
                                                 {{$favorito->anuncio->categoria->titulo}} {{!empty($favorito->anuncio->sub) ? '- '.$favorito->anuncio->sub->titulo : ''}}<br>
                                                 <div class="mt-05"><strong>Publicado em: {{ date('d/m/Y', strtotime($favorito->anuncio->created_at))}}</strong></div>
                                             </div>
                                             <span class="badge badge-{{ $cor[$favorito->anuncio->status] }}">{{ $status[$favorito->anuncio->status] }}</span>
                                         </div>
                                     </div>
                                 </a>
                             </li>
                            @endforeach
                         </ul>
                    </div>
                </div>
                <div class="tab-pane fade" id="settings" role="tabpanel">
                    <div class="section full mt-2 mb-2">
                    <div class="section-title">Dados Pessoais</div>
                    <div class="wide-block pb-1 pt-1">
                        <form action="{{ route('update.perfil.app', Auth::user()->id) }}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="form-group basic">
                                <div class="input-wrapper">
                                    <label class="label" for="name5">Potências</label>
                                    <select id="potencia_id" name="potencia_id" class="form-control">
                                            <option value="">Selecione uma potência</option>
                                            @foreach ($potencias as $potencia)
                                                <option value="{{ $potencia->id }}" {{ Auth::user()->potencia_id == $potencia->id ? 'selected' : '' }}>{{ $potencia->estadual }} - {{ utf8_decode($potencia->nome) }}</option>
                                            @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="form-group basic">
                                <div class="input-wrapper">
                                    <label class="label" for="name5">Loja </label>
                                    <select id="loja_id" name="loja_id" class="form-control">
                                            <option value="{{ !empty(Auth::user()->loja_id) ? Auth::user()->loja_id : '' }}">{{ !empty(Auth::user()->loja_id) ? Auth::user()->loja->numero .'-'. utf8_decode(Auth::user()->loja->loja) : 'Selecione uma loja' }}</option>
                                        @foreach ($lojas as $loja_item)
                                            <option value="{{ $loja_item->id }}">{{ $loja_item->numero }}-{{ utf8_decode($loja_item->loja) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="form-group basic">
                                <div class="input-wrapper">
                                    <label class="label" for="name5">CPF</label>
                                    <input name="cpf" value="{{ Auth::user()->cpf }}" type="tel" class="form-control cpf" id="cpf">
                                </div>
                            </div>
                            <div class="form-group basic">
                                <div class="input-wrapper">
                                    <label class="label" for="name5">Nome </label>
                                    <input value="{{ Auth::user()->name }}" id="name" name="name" type="text"
                                        class="form-control" placeholder="Nome">
                                </div>
                            </div>
                            <div class="form-group basic">
                                <div class="input-wrapper">
                                    <label class="label" for="name5">E-Mail </label>
                                    <input value="{{ Auth::user()->email }}" id="email" name="email" type="text"
                                        class="form-control email" placeholder="E-Mail">
                                </div>
                            </div>
                            <div class="form-group basic">
                                <div class="input-wrapper">
                                    <label class="label" for="name5">Telefone </label>
                                    <input value="{{ Auth::user()->celular }}" id="celular" name="celular" type="tel"
                                        class="form-control celular" placeholder="Telefone">
                                </div>
                            </div>
                            <div class="form-group basic">
                                <div class="input-wrapper">
                                    <label class="label" for="name5">Senha </label>
                                    <input type="password" name="senha" class="form-control" id="senha" autocomplete="no">
                                    <i class="clear-input">
                                        <ion-icon name="close-circle"></ion-icon>
                                    </i>
                                </div>
                            </div>
                            <div class="form-group basic">
                                <div class="input-wrapper">
                                    <label class="label" for="name5">Confirmar Senha </label>
                                    <input type="password" name="senha2" class="form-control" id="senha2"autocomplete="no">
                                    <i class="clear-input">
                                        <ion-icon name="close-circle"></ion-icon>
                                    </i>
                                </div>
                            </div>
                            <div id="mostrar"></div>
                            <button name="salvar" type="submit" class="btn btn-primary btn-block btn-sm">Atualizar Perfil</button>
                        </form>
                    </div>
                </div>
                <!-- * settings -->
            </div>
        </div>
        <!-- * tab content -->

    </div>
    <!-- * App Capsule -->

    @if (session('error'))
            <div id="error" class="toast-box toast-bottom bg-danger">
                <div class="in">
                    <div class="text">
                        {{ session('error') }}
                    </div>
                </div>
                <button type="button" class="btn btn-sm btn-text-light close-button">OK</button>
            </div>
        @endif
        @if (session('success'))
            <div id="success" class="toast-box toast-bottom bg-success">
                <div class="in">
                    <div class="text">
                        {{ session('success') }}
                    </div>
                </div>
                <button type="button" class="btn btn-sm btn-text-light close-button">OK</button>
            </div>
        @endif
@endsection

@section('js')
<script src="{{ url('adm') }}/assets/plugins/global/plugins.bundle.js"></script>


    <script>
        Inputmask({
            "mask": "999.999.999-99"
        }).mask("#cpf");
        Inputmask({
            "mask": "99/99"
        }).mask("#aniv");
        Inputmask({
            "mask": "(99) 99999-9999"
        }).mask("#celular");
        Inputmask({
            "mask": "(99) 9999-9999"
        }).mask("#telefone");
        Inputmask({
            "mask": "99999-999"
        }).mask("#cep");
    </script>

    <script>
        $(document).ready(function() {
            $("#carregando_self").hide();
            $("#cep").on("blur", function() {
                var numCep = $("#cep").val();
                var url = "https://viacep.com.br/ws/" + numCep + "/json";
                $.ajax({
                    url: url,
                    type: "get",
                    dataType: "json",
                    success: function(dados) {
                        console.log(dados);
                        $("#cep").val(dados.cep);
                        $("#endereco").val(dados.logradouro);
                        $("#bairro").val(dados.bairro);
                        $("#cidade").val(dados.localidade);
                        $("#estado").val(dados.uf);
                    }
                })
            });

            @if (session('error'))
                toastbox('error', 3000)
            @endif

            @if (session('success'))
                toastbox('success', 3000)
            @endif

            $("#self").on("change", function() {
                $("#carregando_self").show();
                $("#label_self").hide();
                document.getElementById("formSelf").submit();
            });

            $("#potencia_id").change(function(){
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                    });
                    $.ajax({
                        url: "{{ route('get.lojas') }}",
                        method: 'POST',
                        data: {
                            potencia_id: $("#potencia_id").val(),
                        },
                        success: function(result) {
                            $("#loja_id").html(result);
                        }
                    });
            })

        });
    </script>
@endsection
