@extends('app.base')
@section('content')
    <!-- App Header -->
    <div class="appHeader bg-primary text-light">
        <div class="left">
            <a href="#" class="headerButton" data-toggle="modal" data-target="#sidebarPanel">
                <ion-icon name="menu-outline"></ion-icon>
                @if (!empty(Auth::user()->SetCidade->nome))
                    {{ Auth::user()->SetCidade->nome }}-{{ Auth::user()->SetEstado->uf }}
                @else
                    Menu
                @endif
                {{-- <ion-icon name="chevron-down-outline"></ion-icon> --}}
            </a>
        </div>
        <div class="pageTitle">
            <img src="{{ url('app/assets/img/logo.png') }}" width="200">
        </div>
        <div class="right">
            <a href="javascript:;" class="headerButton toggle-searchbox">
                <ion-icon name="search-outline"></ion-icon>
            </a>
        </div>
    </div>
    <!-- * App Header -->

    <!-- Search Component -->
    <div id="search" class="appHeader">
        <form class="search-form">
            <div class="form-group searchbox">
                <input id="s" type="text" class="form-control" placeholder="Qual serviço esta precisando?">
                <i class="input-icon">
                    <ion-icon name="search-outline"></ion-icon>
                </i>
                <a id="close-searchbox" href="javascript:;" class="ml-1 close toggle-searchbox">
                    <ion-icon name="close-circle"></ion-icon>
                </a>
            </div>
        </form>
    </div>
    <!-- * Search Component -->

    <!-- Search Component -->
    <div id="search" class="appHeader">
        <form class="search-form">
            <div class="form-group searchbox">
                <input id="s" type="text" class="form-control" placeholder="Busca Rápida">
                <i class="input-icon">
                    <ion-icon name="search-outline"></ion-icon>
                </i>
                <a id="close-searchbox" href="javascript:;" class="ml-1 close toggle-searchbox">
                    <ion-icon name="close-circle"></ion-icon>
                </a>
            </div>
        </form>
    </div>
    <!-- * Search Component -->

    <!-- App Capsule -->
    <div id="appCapsule">
        <div id="result"></div>
        <div class="section full mb-3" style="margin-top: 10px;">
            <div class="carousel-single owl-carousel owl-theme">
                @foreach ($banners as $banner)
                    <div class="item">
                        <a href="#" onclick="javascript:window.open('{{route('app.anuncio',$banner->id)}}', '_self')">
                            <img src="{{ url("storage/{$banner->banner}") }}" alt="alt" class="imaged w-100">
                        </a>
                    </div>
                @endforeach
            </div>
        </div>
        <div class="wide-block p-0">
            <div class="table-responsive">
                <table class="table">
                        <tr>
                            <td class="center">
                                <a href="{{ route('app.quem.somos') }}" class="item active">
                                   <img src="{{ url('storage/menu/quem-somos.png') }}" width="40"><br>
                                    Quem Somos
                                </a>
                            </td>
                            <td class="center">
                                <a href="{{ route('app.fundadores') }}" class="item active">
                                   <img src="{{ url('storage/menu/fundadores.png') }}" width="40"><br>
                                    Fundadores
                                </a>
                            </td>
                            <td class="center">
                                <a href="{{ route('app.perguntas') }}" class="item active">
                                   <img src="{{ url('storage/menu/faq.png') }}" width="40"><br>
                                    FAQ
                                </a>
                            </td>
                            <td class="center">
                                <a href="{{ route('app.potencias.estados') }}" class="item active">
                                   <img src="{{ url('storage/menu/maconaria.png') }}" width="40"><br>
                                    Lojas Maçônicas
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td class="center">
                                <a href="{{ route('app.eventos') }}" class="item active">
                                   <img src="{{ url('storage/menu/calendar.png') }}" width="40"><br>
                                    Eventos
                                </a>
                            </td>
                            <td class="center">
                                <a href="{{ route('app.contato') }}" class="item active">
                                   <img src="{{ url('storage/menu/contact-us.png') }}" width="40"><br>
                                    Fale Conosco
                                </a>
                            </td>
                            <td class="center">
                                <a href="{{ route('app.categorias',[0,0]) }}" class="item active">
                                   <img src="{{ url('storage/menu/briefcase.png') }}" width="40"><br>
                                    Anunciantes
                                </a>
                            </td>
                            <td class="center">
                                <a href="{{ route('meu.perfil') }}" class="item active">
                                   <img src="{{ url('storage/menu/profile-user.png') }}" width="40"><br>
                                    Minha Conta
                                </a>
                            </td>
                        </tr>

                </table>
            </div>
        </div>
    </div>

        {{-- <div class="section full mt-3 mb-3">
            <div class="carousel-multiple owl-carousel owl-theme">
                @foreach ($categorias as $categoria)
                    <div class="item center">
                        <a href="{{ route('app.anuncios.categoria',[$categoria->id,0,0]) }}">
                            <img src="{{ url("storage/{$categoria->categoria->ico}") }}" class="card-img-top" alt="image">
                        </a>
                        <div class="card-body pt-2">
                            <a href="{{ route('app.anuncios.categoria',[$categoria->id,0,0]) }}">
                                <h4 class="mb-0">{{ $categoria->categoria->titulo }}</h4>
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
        </div> --}}

        {{-- <ul class="listview image-listview media search-result mb-2">
            @foreach ($anuncios as $anuncio)
            <li>
                <a href="#" onclick="javascript:window.open('{{route('app.anuncio',$anuncio->id)}}', '_self')"  class="item">
                    @if (!empty($anuncio->thumb))
                        <div class="imageWrapper">
                            <img src="{{ url("storage/{$anuncio->thumb}") }}" class="imaged corta-img">
                        </div>
                    @endif
                    <div class="in">
                        <div>
                            <h4 style="margin-top: -20px;" class="mb-05">{{lmWord($anuncio->empresa, 30)}}</h4>
                            <h4 style="" class="mb-05">{{!empty($anuncio->anunciante->tratamento) ? $anuncio->anunciante->tratamento : ''}} {{!empty($anuncio->anunciante->name) ? $anuncio->anunciante->name : ''}}</h4>
                            <h4 style="" class="mb-05">{{$anuncio->cidade}}/{{$anuncio->estado}}</strong>{{!empty($anuncio->bairro) ? ' - '.$anuncio->bairro : ''}}</h4>
                            <div class="text-muted">
                                {!! lmWord($anuncio->descricao,100) !!}
                             </div>
                        </div>
                    </div>
                </a>
            </li>
            @endforeach
        </ul> --}}

        <div class="appFooter sempreDireita">
            <img src="{{ url('adm') }}/assets/images/logo.png" alt="icon">
            <div class="footer-title">
                (16) 99732-2886 | (16) 99992-2886
            </div>
            Rede Maçônica Comercial - Conectando Irmãos
            <div class="mt-2">
                <a href="javascript:return false;" onclick="javascript:window.open('tel:16997322886', '_system');" class="btn btn-icon btn-sm btn-facebook">
                    <ion-icon name="call-outline"></ion-icon>
                </a>
                <a href="javascript:return false;" onclick="javascript:window.open('tel:169999922886', '_system');" class="btn btn-icon btn-sm btn-facebook">
                    <ion-icon name="call-outline"></ion-icon>
                </a>
                <a href="https://www.instagram.com/chibarro_grei/" class="btn btn-icon btn-sm btn-instagram">
                    <ion-icon name="logo-instagram"></ion-icon>
                </a>
                <a href="https://api.whatsapp.com/send?phone=5516999922886&text=Olá estou no aplicativo Chibarro Grei" class="btn btn-icon btn-sm btn-whatsapp">
                    <ion-icon name="logo-whatsapp"></ion-icon>
                </a>
                <a href="https://api.whatsapp.com/send?phone=5516997322886&text=Olá estou no aplicativo Chibarro Grei" class="btn btn-icon btn-sm btn-whatsapp">
                    <ion-icon name="logo-whatsapp"></ion-icon>
                </a>
            </div>
        </div>
    </div>

    <div class="modal fade dialogbox" id="select_regiao" data-backdrop="static" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Selecione sua região</h5>
                </div>
                <form>
                    <div class="modal-body text-left mb-2">
                        <div class="form-group basic">
                            <div class="input-wrapper">
                                <label class="label" for="email1">Estados</label>
                                <select id="estado" class="form-control">
                                    <option value="">Selecione um estado</option>
                                    @foreach ($estados as $est)
                                        <option value="{{ $est->estado}}">{{ $est->setEstado->nome }}</option>
                                    @endforeach
                                </select>
                                <i class="clear-input">
                                    <ion-icon name="close-circle"></ion-icon>
                                </i>
                            </div>
                        </div>
                        <div class="form-group basic">
                            <div class="input-wrapper">
                                <label class="label" for="email1">Cidades</label>
                                <select id="cidade" class="form-control">
                                    <option value="">Selecione uma cidade</option>
                                </select>
                                <i class="clear-input">
                                    <ion-icon name="close-circle"></ion-icon>
                                </i>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="btn-inline">
                            <button type="button" class="btn btn-text-secondary" data-dismiss="modal">CANCELAR</button>
                            <button id="continuar" type="button" class="btn btn-text-primary" data-dismiss="modal">CONTINUAR</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- * App Capsule -->
@endsection
@section('js')
    <script>
        $(document).ready(function(){
            // setTimeout(function(){
            //     $("#select_regiao").modal('show');
            // }, 3000);

            $("#estado").change(function(){
                if($("#estado").val() != ''){
                    $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                    });
                    $.ajax({
                        url: "{{ route('get.cidade') }}",
                        method: 'POST',
                        data: {
                            estado: $("#estado").val(),
                        },
                        success: function(result) {
                            $("#cidade").html(result);
                        }
                    });
                }
            })

            $("#continuar").click(function(){
                if($("#estado").val() != ''){
                    var estado = $("#estado").val();
                }else{
                    var estado = 0;
                }
                if($("#cidade").val() != ''){
                    var cidade = $("#cidade").val();
                }else{
                    var cidade = 0;
                }
                window.location.href = '/home/'+estado+'/'+cidade;
            });

            $("#s").keyup(function(){
                $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
                });
                $.ajax({
                    url: "{{ route('busca.rapida') }}",
                    method: 'POST',
                    data: {
                        s: $("#s").val(),
                        cidade: 0,
                        estado: 0,
                    },
                    success: function(result) {
                        $("#result").show();
                        $("#result").html(result);
                    }
                });
            });

            $("#close-searchbox").click(function(){
                $("#result").hide();
            })

        });
    </script>
@endsection
