@extends('app.base')
@section('content')
    <div class="appHeader bg-primary text-light">
        <div class="left">
            <a href="#" class="headerButton" data-toggle="modal" data-target="#sidebarPanel">
                <ion-icon name="menu-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
            <img src="{{ url('app/assets/img/bode1.png') }}" height="30"> FUNDADORES <img src="{{ url('app/assets/img/bode2.png') }}" height="30">
        </div>
        <div class="right">
            <a href="{{ route('app.filtros') }}" class="headerButton">
                <ion-icon name="search-outline"></ion-icon>
            </a>
        </div>
    </div>
    <div id="appCapsule">
        <div class="section mt-2">
            <div class="row">
                @foreach ($fundadores as $fundador)
                    <div class="col-6 mb-2">
                        <div class="card product-card">
                            <div class="card-body">
                                <img src="{{!empty($fundador->foto) ? url("storage/{$fundador->foto}") : url('admin/assets/media/user.png')}}" class="image" alt="{{$fundador->name}}">
                                <h2 class="title">{{lmWord($fundador->name,20)}}</h2>
                                <div class="price">{{$fundador->celular}}</div>
                                <a href="https://api.whatsapp.com/send?1=pt_BR&phone=55{{tiraMoeda($fundador->celular)}}&text=Olá {{$fundador->name}}, eu estou no *Aplicativo {{env('APP_NAME')}}*" target="_blank" class="btn btn-sm btn-primary btn-block">CONVERSAR</a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
@endsection
