@extends('app.base')
@section('content')
    <div class="appHeader bg-primary text-light">
        <div class="left">
            <a href="#" onclick="history.back()" class="headerButton">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
            EVENTOS
        </div>
        <div class="right">
            <a href="javascript:;" class="headerButton toggle-searchbox">
                <ion-icon name="search-outline"></ion-icon>
            </a>
        </div>
    </div>

    <!-- Search Component -->
    <div id="search" class="appHeader">
        <form class="search-form">
            <div class="form-group searchbox">
                <input type="text" class="form-control" placeholder="Busca rápida...">
                <i class="input-icon">
                    <ion-icon name="search-outline"></ion-icon>
                </i>
                <a href="javascript:;" class="ml-1 close toggle-searchbox">
                    <ion-icon name="close-circle"></ion-icon>
                </a>
            </div>
        </form>
    </div>
    <!-- * Search Component -->

    <div id="appCapsule">
        @foreach ($eventos as $evento)
            <div class="section mt-2">
                <a href="{{ route('app.evento',$evento->id) }}">
                    <div class="card">
                        <img src="{{ url("storage/{$evento->image}") }}" class="card-img-top" alt="image">
                        <div class="card-body">
                            <h5 class="card-title">{{ $evento->titulo }}</h5>
                            <p>{{ lmWord($evento->descricao,100) }}</p>
                            <p class="card-text"><small>{{ date('d/m/Y H:i', strtotime($evento->created_at)) }}</small></p>
                        </div>
                    </div>
                </a>
            </div>
        @endforeach
    </div>
@endsection
