@extends('app.base')
@section('content')
    <!-- App Header -->
    <div class="appHeader bg-primary text-light">
        <div class="left">
            <a href="#" onclick="history.back()" class="headerButton">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">Novo Anúncio</div>
        <div class="right">
        </div>
    </div>
    <!-- * App Header -->

    <!-- App Capsule -->
    <div id="appCapsule">
        <form method="post" enctype="multipart/form-data" action="{{ route('app.update.anuncio',$anuncio->id) }}">
            @csrf
        {{-- <div class="section full mt-2 mb-2">
                <div class="section-title">Imagem</div>
                <div class="wide-block pb-2 pt-2">

                    <div class="custom-file-upload">
                        <input type="file" id="fileuploadInput" name="thumb" accept=".png, .jpg, .jpeg">
                        <label for="fileuploadInput">
                            <span>
                                <strong>
                                    @if (!empty($anuncio->thumb))
                                        <img src="{{ url("storage/{$anuncio->thumb}") }}" width="100%">
                                    @else
                                        <ion-icon name="cloud-upload-outline"></ion-icon>
                                    @endif
                                    <i>Toque para Anexar</i>
                                </strong>
                            </span>
                        </label>
                    </div>
                </div>
        </div> --}}

        <div class="section full mt-2 mb-2">
            <div class="section-title">Dados do Anúncio</div>
            <div class="wide-block pb-1 pt-1">
                <div class="form-group basic">
                    <div class="input-wrapper">
                        <label class="label" for="city4">Categorias</label>
                        <select class="form-control custom-select" id="categoria_id" name="categoria_id">
                            <option value="0">Selecione uma categoria</option>
                            @foreach ($categorias as $categoria)
                                <option value="{{ $categoria->id }}" {{ $categoria->id == $anuncio->categoria_id ? 'selected' : ''}} >{{ $categoria->titulo }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="form-group basic" id="box_sub_categoria">
                    <div class="input-wrapper">
                        <label class="label" for="city4">Sub Categorias</label>
                        <select class="form-control custom-select" id="sub_categoria_id" name="sub_categoria_id">
                            @if (!empty($anuncio->sub_categoria_id))
                                <option value="{{ $anuncio->sub_categoria_id }}">{{ $anuncio->sub->titulo }}</option>
                            @endif
                            <option value="">Selecione uma categoria</option>
                        </select>
                    </div>
                </div>
                <div class="form-group basic">
                    <div class="input-wrapper">
                        <label class="label" for="name1">Nome da Empresa</label>
                        <input type="text" class="form-control" name="empresa" id="empresa" value="{{ $anuncio->empresa }}">
                        <i class="clear-input">
                            <ion-icon name="close-circle"></ion-icon>
                        </i>
                    </div>
                </div>
                <div class="form-group basic">
                    <div class="input-wrapper">
                        <label class="label" for="address4">Descrição</label>
                        <textarea name="descricao" id="descricao" rows="6" class="form-control">{{ $anuncio->descricao }}</textarea>
                        <i class="clear-input">
                            <ion-icon name="close-circle"></ion-icon>
                        </i>
                    </div>
                </div>
                <div class="form-group basic">
                    <div class="input-wrapper">
                        <label class="label" for="name5">Telefone </label>
                        <input value="{{ Auth::user()->celular }}" id="celular" name="celular" type="tel"
                            class="form-control celular" value="Telefone">
                    </div>
                </div>
                <button type="button"  class="btn btn-primary btn-block btn-sm" data-toggle="modal" data-target="#SHowModalTelefone">Adicionar Telefone</button>

                <div class="table-responsive">
                    <table class="table table-striped">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th scope="col">Tipo</th>
                                    <th scope="col">Número</th>
                                    <th scope="col">Ações</th>
                                </tr>
                            </thead>
                            <tbody  id="listar_telefones">
                                @foreach ($telefones as $telefone)
                                <tr id="tel{{$telefone->id}}">
                                    <td>{{$telefone->tipo}}</td>
                                    <td>{{formataTelefone($telefone->numero)}}</td>
                                    <td>
                                        <button class="btn btn-icon btn-sm btn-gander mr-1 mb-1" type="button" onclick="javascript:exTel({{$telefone->id}})"><ion-icon name="trash-outline"></ion-icon></button>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </table>
                </div>
                <!-- Dialog Form -->
                <div class="modal fade dialogbox" id="SHowModalTelefone" data-backdrop="static" tabindex="-1" role="dialog">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Cadastro de Telefones</h5>
                        </div>

                            <div class="modal-body text-left mb-2">
                                <div class="form-group basic">
                                    <div class="input-wrapper">
                                        <label class="label" for="email1">Tipo</label>
                                        <select type="text" id="tipo" class="form-control">
                                            <option value="Fixo">Fixo</option>
                                            <option value="Celular">Celular</option>
                                            <option value="Whatsapp">Whatsapp</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group basic">
                                    <div class="input-wrapper">
                                        <label class="label" for="password1">Número</label>
                                        <input type="tel" class="form-control" id="contato"
                                            value="(XX) XXXXX-XXXX">
                                        <i class="clear-input"> <ion-icon name="close-circle"></ion-icon>
                                        </i>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <div class="btn-inline">
                                    <button type="button" class="btn btn-text-primary" data-dismiss="modal">FECHAR</button>
                                    <button type="button" name="executar" class="btn" id="addTelefone" class="btn btn-text-secondary">ADICIONAR</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <!-- * Dialog Form -->

            <div class="form-group basic">
                <div class="input-wrapper">
                    <label class="label" for="name5">E-Mail </label>
                    <input value="{{ $anuncio->email }}" id="email" name="email" type="text"
                        class="form-control email" value="E-Mail">
                </div>
            </div>
                <div class="form-group basic">
                    <div class="input-wrapper">
                        <label class="label" for="name1">Instagram</label>
                        <input type="text" class="form-control" id="instagram" name="instagram" value="{{ $anuncio->instagram }}">
                        <i class="clear-input">
                            <ion-icon name="close-circle"></ion-icon>
                        </i>
                    </div>
                </div>
                <div class="form-group basic">
                    <div class="input-wrapper">
                        <label class="label" for="name1">Facebook</label>
                        <input type="text" class="form-control" id="facebook" name="facebook" value="{{ $anuncio->facebook }}">
                        <i class="clear-input">
                            <ion-icon name="close-circle"></ion-icon>
                        </i>
                    </div>
                </div>
                <div class="form-group basic">
                    <div class="input-wrapper">
                        <label class="label" for="name1">Site</label>
                        <input type="text" class="form-control" id="site" name="site" value="{{ $anuncio->site }}">
                        <i class="clear-input">
                            <ion-icon name="close-circle"></ion-icon>
                        </i>
                    </div>
                </div>
                <div class="form-group basic">
                    <div class="input-wrapper">
                        <label class="label" for="name5">CEP </label>
                        <input name="cep" value="{{ $anuncio->cep }}" id="cep" onblur="validarCEP();" type="tel"
                            class="form-control cep">
                        <div id="carregando_cep"></div>
                    </div>
                </div>
                <div class="form-group basic">
                    <div class="input-wrapper">
                        <label class="label" for="name5">Endereço </label>
                        <input name="endereco" value="{{ $anuncio->endereco }}" id="endereco" type="text"
                            class="form-control">
                    </div>
                </div>
                <div class="form-group basic">
                    <div class="input-wrapper">
                        <label class="label" for="name5">Nº </label>
                        <input name="numero" value="{{ $anuncio->numero }}" id="numero" type="text"
                            class="form-control">
                    </div>
                </div>
                <div class="form-group basic">
                    <div class="input-wrapper">
                        <label class="label" for="name5">Complemento </label>
                        <input name="complemento" value="{{ $anuncio->complemento }}" id="complemento" type="text"
                            class="form-control">
                    </div>
                </div>
                <div class="form-group basic">
                    <div class="input-wrapper">
                        <label class="label" for="name5">Bairro </label>
                        <input name="bairro" value="{{ $anuncio->bairro }}" id="bairro" type="text"
                            class="form-control">
                    </div>
                </div>
                <div class="form-group basic">
                    <div class="input-wrapper">
                        <label class="label" for="name5">Cidade </label>
                        <input name="cidade" value="{{ $anuncio->cidade }}" id="cidade" type="text"
                            class="form-control">
                    </div>
                </div>
                <div class="form-group basic">
                    <div class="input-wrapper">
                        <label class="label" for="name5">Estado </label>
                        <select id="estado" name="estado" class="form-control">
                            <option value="{{ $anuncio->estado }}" selected>{{ $anuncio->estado }}
                            </option>
                            <option value="BA">Bahia</option>
                            <option value="AC">Acre</option>
                            <option value="AL">Alagoas</option>
                            <option value="AP">Amapá</option>
                            <option value="AM">Amazonas</option>
                            <option value="CE">Ceará</option>
                            <option value="DF">Distrito Federal</option>
                            <option value="ES">Espírito Santo</option>
                            <option value="GO">Góias</option>
                            <option value="MA">Maranhão</option>
                            <option value="MT">Mato Grosso</option>
                            <option value="MS">Mato Grosso do Sul</option>
                            <option value="MG">Minas Gerais</option>
                            <option value="PA">Pará</option>
                            <option value="PB">Paraíba</option>
                            <option value="PR">Paraná</option>
                            <option value="PE">Pernambuco</option>
                            <option value="PI">Piauí</option>
                            <option value="RJ">Rio de Janeiro</option>
                            <option value="RN">Rio Grande do Norte</option>
                            <option value="RS">Rio Grande do Sul</option>
                            <option value="RO">Rondônia</option>
                            <option value="RR">Roraima</option>
                            <option value="TO">Tocantins</option>
                            <option value="SC">Santa Catarina</option>
                            <option value="SP">São Paulo</option>
                            <option value="SE">Sergipe</option>
                        </select>
                    </div>
                </div>
                <button name="salvar" type="submit" class="btn btn-primary btn-block btn-sm mb-5">Atualizar Anúncio</button>
            </div>


        </div>
    </form>
    </div>

    <div id="pagar" class="notification-box">
        <div class="notification-dialog ios-style bg-success">
            <div class="notification-header">
                <div class="in">
                    <strong>{{ env('APP_NAME') }}</strong>
                </div>
                <div class="right">
                    <span>fechar</span>
                    <a href="#" class="close-button">
                        <ion-icon name="close-circle"></ion-icon>
                    </a>
                </div>
            </div>
            <div class="notification-content">
                <div class="in">
                    <h3 class="subtitle">Olá {{ Auth::user()->name }}</h3>
                    <div class="text">
                        Quer levar vantagem?
                    </div>
                </div>
            </div>
            <div class="notification-footer">
                <a href="https://api.whatsapp.com/send?1=pt_BR&phone=5516999922886&text=Olá estou no aplicativo da {{ env('APP_NAME') }} e gostaria de informações para anúncios patrocinados" class="notification-button">
                    Sim
                </a>
                <a href="#" class="notification-button close-button"">
                    Não
                </a>
            </div>
        </div>
    </div>
    <!-- * App Capsule -->
@endsection

@section('js')
    <script src="{{ url('adm') }}/assets/plugins/global/plugins.bundle.js"></script>


    <script>
        Inputmask({
            "mask": "(99) 99999-9999"
        }).mask("#contato");
        Inputmask({
            "mask": "999.999.999-99"
        }).mask("#cpf");
        Inputmask({
            "mask": "99/99"
        }).mask("#aniv");
        Inputmask({
            "mask": "(99) 99999-9999"
        }).mask("#celular");
        Inputmask({
            "mask": "(99) 9999-9999"
        }).mask("#telefone");
        Inputmask({
            "mask": "99999-999"
        }).mask("#cep");
    </script>

    <script>
        $(document).ready(function() {

            notification('pagar');

            $("#box_sub_categoria").hide();
            $("#categoria_id").change(function() {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: "{{ route('get.categorias') }}",
                    method: 'POST',
                    data: {
                        categoria_id: $("#categoria_id").val()
                    },
                    success: function(result) {
                        if (result) {
                            $("#box_sub_categoria").show();
                            $("#sub_categoria_id").html(result);
                        }
                    }
                });
            });


            $("#cep").on("blur", function() {
                var numCep = $("#cep").val();
                var url = "https://viacep.com.br/ws/" + numCep + "/json";
                $.ajax({
                    url: url,
                    type: "get",
                    dataType: "json",
                    success: function(dados) {
                        console.log(dados);
                        $("#cep").val(dados.cep);
                        $("#endereco").val(dados.logradouro);
                        $("#bairro").val(dados.bairro);
                        $("#cidade").val(dados.localidade);
                        $("#estado").val(dados.uf);
                    }
                })
            });

            $("#addTelefone").on("click",function() {
                $("#SHowModalTelefone").modal('hide');
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: "{{route('add.telefone')}}",
                    method: 'POST',
                    data: {
                        anuncio_id: {{ $anuncio->id }},
                        tipo: $("#tipo").val(),
                        numero: $("#contato").val()
                    },
                    success: function(result) {
                        $("#listar_telefones").html(result);
                    }
                });
            });

            @if (session('error'))
                toastbox('error', 3000)
            @endif

            @if (session('success'))
                toastbox('success', 3000)
            @endif

            $("#self").on("change", function() {
                $("#carregando_self").show();
                $("#label_self").hide();
                document.getElementById("formSelf").submit();
            });

        });

        function exTel(id){
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('remove.telefone') }}",
                method: 'POST',
                data: {
                    id: id,
                },
                success: function(result) {
                    $("#tel" + id).hide();
                }
            });
        }
    </script>
@endsection
