@extends('app.base')
@section('content')
    <div class="appHeader bg-primary text-light">
        <div class="left">
            <a href="#" class="headerButton" data-toggle="modal" data-target="#select_regiao">
                <ion-icon name="location"></ion-icon>
                @if (!empty(Auth::user()->SetCidade->nome))
                    {{ Auth::user()->SetCidade->nome }}-{{ Auth::user()->SetEstado->uf }}
                @else
                {{ !empty($cidade) ? $cidade : '' }} {{ !empty($estado) ? $estado : 'Escolher uma localização' }}
                @endif
                <ion-icon name="chevron-down-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">

        </div>
        <div class="right">
            {{-- <a href="{{ route('app.categorias',[$estado,$cidade]) }}" class="headerButton">
                <ion-icon name="search-outline"></ion-icon>
            </a> --}}
        </div>
    </div>
    <div id="appCapsule">
        <ul class="listview image-listview mb-50">
            @foreach ($categorias as $categoria)
                <li>
                    <a href="{{ route('app.anuncios.categoria', [$categoria->categoria_id,$estado,$cidade]) }}" class="item">
                        <img src="{{url("storage/{$categoria->categoria->ico}")}}" alt="image" class="image">
                        <div class="in">
                            <div>{{$categoria->level1}}</div>
                            {{-- @if (!empty($cidade))
                                <span class="badge badge-primary">{{ count($categoria->categoria->anuncios->where('cidade',$cidade)) }}</span>
                            @elseif (!empty($estado))
                                <span class="badge badge-primary">{{ count($categoria->categoria->anuncios->where('estado',$estado)) }}</span>
                            @else
                                <span class="badge badge-primary">{{ count($categoria->categoria->anuncios) }}</span>
                            @endif --}}
                        </div>
                    </a>
                </li>
            @endforeach
        </ul>
    </div>
    <div class="modal fade dialogbox" id="select_regiao" data-backdrop="static" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Selecione sua região</h5>
                </div>
                <form>
                    <div class="modal-body text-left mb-2">
                        <div class="form-group basic">
                            <div class="input-wrapper">
                                <label class="label" for="email1">Estados</label>
                                <select id="estado" class="form-control">
                                    <option value="" selected>Selecione um estado</option>
                                    @foreach ($estados as $est)
                                        <option value="{{ $est->estado}}">{{ $est->setEstado->nome }}</option>
                                    @endforeach
                                </select>
                                <i class="clear-input">
                                    <ion-icon name="close-circle"></ion-icon>
                                </i>
                            </div>
                        </div>
                        <div class="form-group basic">
                            <div class="input-wrapper">
                                <label class="label" for="email1">Cidades</label>
                                <select id="cidade" class="form-control">
                                    <option value="">Selecione uma cidade</option>
                                </select>
                                <i class="clear-input">
                                    <ion-icon name="close-circle"></ion-icon>
                                </i>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="btn-inline">
                            <button type="button" class="btn btn-text-secondary" data-dismiss="modal">CANCELAR</button>
                            <button id="continuar" type="button" class="btn btn-text-primary" data-dismiss="modal">CONTINUAR</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        $(document).ready(function(){
            $("#estado").change(function(){
                if($("#estado").val() != ''){
                    $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                    });
                    $.ajax({
                        url: "{{ route('get.cidade') }}",
                        method: 'POST',
                        data: {
                            estado: $("#estado").val(),
                        },
                        success: function(result) {
                            $("#cidade").html(result);
                        }
                    });
                }
            })

            $("#continuar").click(function(){
                if($("#estado").val() != ''){
                    var estado = $("#estado").val();
                }else{
                    var estado = 0;
                }
                if($("#cidade").val() != ''){
                    var cidade = $("#cidade").val();
                }else{
                    var cidade = 0;
                }
                window.location.href = '/home/'+estado+'/'+cidade;
            });
        });
    </script>
@endsection
