@extends('app.base')
@section('content')
    <div class="appHeader bg-primary text-light">
        <div class="left">
            <a href="javascript:;" class="headerButton goBack">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">{{ $anuncios[0]->level2 }}</div>
        <div class="right">
            <a href="javascript:;" data-toggle="modal" data-target="#filtrar" class="headerButton">
                Filtrar <ion-icon name="filter-circle-outline"></ion-icon>
            </a>
        </div>
    </div>
    <!-- App Capsule -->
    <div id="appCapsule">
        <ul class="listview image-listview media search-result mb-2">
            @foreach ($anuncios as $anuncio)
            <li>
                <a href="#" onclick="javascript:window.open('{{route('app.anuncio',$anuncio->id)}}', '_self')"  class="item">
                    @if (!empty($anuncio->thumb))
                        <div class="imageWrapper">
                            <img src="{{ url("storage/{$anuncio->thumb}") }}" class="imaged corta-img">
                        </div>
                    @endif
                    <div class="in">
                        <div>
                            <h4 style="margin-top: -20px;" class="mb-05">{{lmWord($anuncio->empresa, 30)}}</h4>
                            <h4 style="" class="mb-05">{{!empty($anuncio->anunciante->tratamento) ? $anuncio->anunciante->tratamento : ''}} {{!empty($anuncio->anunciante->name) ? $anuncio->anunciante->name : ''}}</h4>
                            <h4 style="" class="mb-05">{{$anuncio->cidade}}/{{$anuncio->estado}}</strong>{{!empty($anuncio->bairro) ? ' - '.$anuncio->bairro : ''}}</h4>
                            <div class="text-muted">
                                {!! lmWord($anuncio->descricao,100) !!}
                             </div>
                        </div>
                    </div>
                </a>
            </li>
            @endforeach
        </ul>
    </div>

    <div class="modal fade modalbox" id="filtrar" data-backdrop="static" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Filtrar</h5>
                    <a href="javascript:;" data-dismiss="modal">Fechar</a>
                </div>
                <div class="modal-body p-0">
                    <ul class="listview link-listview">
                        @foreach ($level2 as $item)
                            <li>
                                <a href="{{ route('app.categoria.level2',[$item->categoria_id,$item->sub_categoria_id,$estado,$cidade]) }}" id="close_modal" >
                                    {{ $item->level2 }}
                                </a>
                            </li>
                        @endforeach
                        <li>
                            <a href="{{ route('app.anuncios.categoria',[$item->categoria_id,$estado,$cidade]) }}" id="close_modal" >
                                {{ $anuncios[0]->level1 }}
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- * App Capsule -->
@endsection
@section('js')
<script>
    $(document).ready(function() {
        $("#close_modal").click(function() {
            $("#filtrar").modal('hide');
        });
    });
    </script>
@endsection
