@extends('app.base')
@section('content')
    <div class="appHeader bg-primary text-light">
        <div class="left">
            <a href="{{ route('app.categorias',[$estado,$cidade]) }}" class="headerButton">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
            {{!empty($categoria->titulo) ? $categoria->titulo : 'Anuncios'}}
        </div>
        <div class="right">
            <a href="javascript:;" data-toggle="modal" data-target="#filtrar" class="headerButton">
                Filtrar <ion-icon name="filter-circle-outline"></ion-icon>
            </a>
        </div>
    </div>
    <div id="appCapsule">
        <div class="section full">
            <ul class="listview image-listview media search-result mb-2" id="result">
                @foreach ($anuncios as $anuncio)
                <li>
                    <a href="#" onclick="javascript:window.open('{{route('app.anuncio',$anuncio->id)}}', '_self')"  class="item">
                        @if (!empty($anuncio->thumb))
                            <div class="imageWrapper">
                                <img src="{{ url("storage/{$anuncio->thumb}") }}" class="imaged corta-img">
                            </div>
                        @endif
                        <div class="in">
                            <div>
                                <h4 style="margin-top: -20px;" class="mb-05">{{lmWord($anuncio->empresa, 30)}}</h4>
                                <h4 style="" class="mb-05">{{!empty($anuncio->anunciante->tratamento) ? $anuncio->anunciante->tratamento : ''}} {{!empty($anuncio->anunciante->name) ? $anuncio->anunciante->name : ''}}</h4>
                                <h4 style="" class="mb-05">{{$anuncio->cidade}}/{{$anuncio->estado}}</strong>{{!empty($anuncio->bairro) ? ' - '.$anuncio->bairro : ''}}</h4>
                                <div class="text-muted">
                                    {!! lmWord($anuncio->descricao,100) !!}
                                 </div>
                            </div>
                        </div>
                    </a>
                </li>
               @endforeach
               @foreach ($free as $anuncio)
                <li>
                    <a href="#" onclick="javascript:window.open('{{route('app.anuncio',$anuncio->id)}}', '_self')"  class="item">
                        @if (!empty($anuncio->thumb))
                            <div class="imageWrapper">
                                <img src="{{ url("storage/{$anuncio->thumb}") }}" class="imaged corta-img">
                            </div>
                        @endif
                        <div class="in">
                            <div>
                                <h4 style="" class="mb-05">{{lmWord($anuncio->empresa, 30)}}</h4>
                                <h4 style="" class="mb-05">{{!empty($anuncio->anunciante->tratamento) ? $anuncio->anunciante->tratamento : ''}} {{!empty($anuncio->anunciante->name) ? $anuncio->anunciante->name : ''}}</h4>
                                <h4 style="" class="mb-05">{{$anuncio->cidade}}/{{$anuncio->estado}}</strong>{{!empty($anuncio->bairro) ? ' - '.$anuncio->bairro : ''}}</h4>
                                <div class="text-muted">
                                    {!! lmWord($anuncio->descricao,100) !!}
                                </div>
                            </div>
                        </div>
                    </a>
                </li>
               @endforeach
            </ul>
        </div>
    </div>
    <div class="modal fade modalbox" id="filtrar" data-backdrop="static" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Filtrar</h5>
                    <a href="javascript:;" data-dismiss="modal">Fechar</a>
                </div>
                <div class="modal-body p-0">
                    <ul class="listview link-listview">
                        @foreach ($level2 as $item)
                            <li>
                                <a href="{{ route('app.categoria.level2',[$item->categoria_id,$item->sub_categoria_id,$estado,$cidade]) }}" id="close_modal" >
                                    {{ $item->level2 }}
                                </a>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        $(document).ready(function(){
            $("#estado").change(function(){
                if($("#estado").val() != ''){
                    $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                    });
                    $.ajax({
                        url: "{{ route('get.cidade') }}",
                        method: 'POST',
                        data: {
                            estado: $("#estado").val(),
                        },
                        success: function(result) {
                            $("#cidade").html(result);
                        }
                    });
                }
            })

            $("#continuar").click(function(){
                if($("#estado").val() != ''){
                    var estado = $("#estado").val();
                }else{
                    var estado = 0;
                }
                if($("#cidade").val() != ''){
                    var cidade = $("#cidade").val();
                }else{
                    var cidade = 0;
                }
                window.location.href = '/home/'+estado+'/'+cidade;
            });
        });
    </script>
@endsection

