@extends('app.base')
@section('titulo',$anuncio->fantasia)
@section('url',route('anuncio.show',$anuncio->id))
@section('title',$anuncio->fantasia)
@section('description', 'Fale agora com '.$anuncio->titulo_id.' '.$anuncio->nome)
@section('image', $anuncio->thumb))

@section('content')
{{-- {{ dd($anuncio) }} --}}
    <!-- App Header -->
    <div class="appHeader bg-primary text-light">
        <div class="pageTitle">{{ $anuncio->fantasia }}</div>
    </div>

    <div id="adicionado" class="toast-box toast-top bg-success">
        <div class="in">
            <div class="text">
                Anúncio salvo em favoritos
            </div>
        </div>
        <button type="button" class="btn btn-sm btn-text-light close-button">OK</button>
    </div>
    <div id="removido" class="toast-box toast-top bg-danger">
        <div class="in">
            <div class="text">
                Anúncio removido de favoritos
            </div>
        </div>
        <button type="button" class="btn btn-sm btn-text-light close-button">OK</button>
    </div>

    <!-- App Capsule -->
    <div id="appCapsule">
        <div class="mb-1">
            @if (!empty($anuncio->thumb))
            <a class="example-image-link" href="{{ $anuncio->thumb }}" data-lightbox="example-set">
                <img src="{{ $anuncio->thumb }}" alt="image" class="imaged img-fluid">
            </a>
            <br><br>
            @endif
            <a href="https://api.whatsapp.com/send?1=pt_BR&text=Olha o anúncio que encontrei no Aplicativo da {{ env('APP_NAME') }}: {{ $anuncio->titulo }}, {{ route('app.anuncio', $anuncio->id) }}" target="system" class="btn btn-success btn-sm btn-block">
                <ion-icon name="logo-whatsapp"></ion-icon> Compartilhar
            </a>
        </div>

        <div class="section full">
            <div class="wide-block pt-2 pb-2 product-detail-header">
                <h1 class="title">{{ $anuncio->fantasia }}</h1>
                <h1 class="title">{{ $anuncio->titulo_ir }} {{ $anuncio->nome }}</h1>
                <div class="text">{{ $anuncio->categoria }}</div>
                <div class="text">{!! $anuncio->descricao !!}</div>
                <div class="text">Publicado em {{ date('d/m/Y', strtotime($anuncio->created_at)) }}</div>
            </div>
        </div>

        <div class="section full mt-2">
            <div class="section-title">Informações e Contatos</div>
            <div class="wide-block pt-2 pb-2">
                <div class="row">
                    <div class="col-12">
                        @foreach ($anuncio->telefones as $telefone)
                            <a href="{{ $telefone->tipo == 'Whatsapp'? 'https://api.whatsapp.com/send?1=pt_BR&phone=+55' .tiraMoeda($telefone->numero) .'&text= Olá vi seu anúncio no aplicativo da ' .env('APP_NAME'): 'tel:' . tiraMoeda($telefone->numero) }}">
                                <div class="accordion-header">
                                    <ion-icon name="{{ $ico[$telefone->tipo] }}"></ion-icon>
                                    {{ $telefone->numero }}
                                </div>
                            </a>
                        @endforeach
                    </div>
                    @if (!empty($anuncio->email))
                        <div class="col-12">
                            <a href="mailto:{{$anuncio->email}}" target="_system">
                                <div class="accordion-header">
                                    <ion-icon name="mail-outline"></ion-icon>
                                    {{$anuncio->email}}
                                </div>
                            </a>
                        </div>
                    @endif
                    <div class="col-12 center">
                        @if (!empty($anuncio->instagram))
                                <a href="{{ $anuncio->instagram }}" target="_system">
                                    <span class="iconedbox iconedbox-lg">
                                        <ion-icon name="logo-instagram"></ion-icon>
                                    </span>
                                </a>
                            @endif
                            @if (!empty($anuncio->facebook))
                                <a href="{{ $anuncio->facebook }}" target="_system">
                                    <span class="iconedbox iconedbox-lg">
                                        <ion-icon name="logo-facebook"></ion-icon>
                                    </span>
                                </a>
                            @endif
                            @if (!empty($anuncio->site))
                                <a href="{{ $anuncio->site }}" target="_system">
                                    <span class="iconedbox iconedbox-lg">
                                        <ion-icon name="globe-outline"></ion-icon>
                                    </span>
                                </a>
                            @endif
                    </div>
                </div>
            </div>
        </div>
        <div class="section full mt-2" style="margin-bottom: 100px;">
            <div class="section-title">Localização</div>
            <div class="wide-block pt-2 pb-2">
                <div class="row">
                    <div class="col-12">
                        <div class="accordion-header">
                            <ion-icon name="location-outline"></ion-icon>
                            Endereço: {{$anuncio->endereco}}, {{$anuncio->numero}} {{$anuncio->complemento}} {{$anuncio->bairro}} {{$anuncio->cidade}} {{$anuncio->estado}}-{{$anuncio->cep}}
                            <button type="button" class="btn btn-primary btn-sm btn-block" data-toggle="modal" data-target="#ComoChegar">COMO CHEGAR?</button>
                        </div>
                        <!-- Share Action Sheet -->
                        <div class="modal fade action-sheet inset" id="ComoChegar" tabindex="-1" role="dialog">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Abrir Localização</h5>
                                    </div>
                                    <div class="modal-body">
                                        <div class="action-sheet-content text-center">
                                            <div class="row">
                                                <div class="col-6">
                                                    <a href="https://www.google.com/maps?q={{$anuncio->endereco}}+{{$anuncio->numero}}+{{$anuncio->complemento}}+{{$anuncio->bairro}}+{{$anuncio->cidade}}+{{$anuncio->estado}}+{{$anuncio->cep}}" class="btn btn-icon">
                                                        <img src="{{url('app/assets/img/mapa.png')}}" width="35" />
                                                    </a>
                                                </div>
                                                <div class="col-6">
                                                    <a href="https://www.waze.com/ul?q={{$anuncio->endereco}}+{{$anuncio->numero}}+{{$anuncio->complemento}}+{{$anuncio->bairro}}+{{$anuncio->cidade}}+{{$anuncio->estado}}+{{$anuncio->cep}}"  class="btn btn-icon">
                                                        <img src="{{url('app/assets/img/waze.png')}}" width="35" />
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- * Share Action Sheet -->
                    </div>
                </div>
            </div>
        </div>
        <div class="fab-button text bottom-center">
            <a href="#" class="fab" data-toggle="modal" data-target="#Ligar">
                <ion-icon name="call-outline"></ion-icon>
                Ligar
            </a>
        </div>
        <!-- Iconed Action Sheet -->
        <div class="modal fade action-sheet" id="Ligar" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Números Disponíveis</h5>
                    </div>
                    <div class="modal-body">
                        <ul class="action-button-list">
                            @foreach ($anuncio->telefones as $telefone)
                            <li>
                                @if ($telefone->tipo == 'Whatsapp')
                                    <a href="https://api.whatsapp.com/send?1=pt_BR&phone=+55+result.telefone+&text= Olá vi seu anúncio no aplicativo da {{ env('APP_NAME') }}" onclick="javascript:Ligar({{ $telefone->id }})" class="btn btn-list text-primary">
                                @else
                                    <a href="tel:{{ setUri2($telefone->numero) }}" class="btn btn-list text-primary">
                                @endif
                                    <span>
                                        <ion-icon name="{{ $ico[$telefone->tipo] }}"></ion-icon>
                                        {{ $telefone->numero }}
                                    </span>
                                </a>
                            </li>
                            @endforeach
                            <!--href="javascript:return false;" onclick="javascript:window.open('tel:38984132243', '_system');"-->
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- * App Capsule -->
@endsection
@section('download')
<div id="download" class="notification-box">
    <div class="notification-dialog android-style">
        <div class="notification-header">
            <div class="in">
                <img src="{{ url("storage/ico.png") }}" alt="image" class="imaged w100">
                <div style="width: 100%">
                    <h3 class="subtitle">Agenda Maçônica Brasil</h3>
                    <div class="text">
                        Baixe Nosso Aplicativo
                    </div>
                </div>
            </div>
        </div>
        <div class="notification-footer">
            <a href="https://apps.apple.com/br/app/agenda-ma%C3%A7%C3%B4nica/id6468433847" class="notification-button">
                <ion-icon name="logo-apple-appstore"></ion-icon>
                Appe Store
            </a>
            <a href="https://play.google.com/store/apps/details?id=com.agendamaconica.cliente" class="notification-button">
                <ion-icon name="logo-google-playstore"></ion-icon>
                Google Play
            </a>
        </div>
    </div>
</div>
@endsection
@section('js')
    <script src="{{ url('adm') }}/assets/plugins/global/plugins.bundle.js"></script>

    <script>
        Inputmask({
            "mask": "(99) 99999-9999"
        }).mask("#contato");
        Inputmask({
            "mask": "999.999.999-99"
        }).mask("#cpf");
        Inputmask({
            "mask": "99/99"
        }).mask("#aniv");
        Inputmask({
            "mask": "(99) 99999-9999"
        }).mask("#celular");
        Inputmask({
            "mask": "(99) 9999-9999"
        }).mask("#telefone");
        Inputmask({
            "mask": "99999-999"
        }).mask("#cep");
    </script>

    <script>

        function Ligar(id){
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('app.ligar') }}",
                method: 'POST',
                data: {
                    id: id,
                },
                success: function(result) {

                }
            });
        }
    </script>
@endsection
