@extends('layouts.base')
@section('titulo', 'Trabalhos Maçônicos')
@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="toolbar" id="kt_toolbar">
            <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
                <div data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}" class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
                    <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">Trabalhos Maçônicos</h1>
                    <span class="h-20px border-gray-200 border-start mx-4"></span>
                    <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                        <li class="breadcrumb-item text-muted">
                            <a href="{{ route('admin.home') }}" class="text-muted text-hover-primary">Home</a>
                        </li>
                        <li class="breadcrumb-item">
                            <span class="bullet bg-gray-200 w-5px h-2px"></span>
                        </li>
                        <li class="breadcrumb-item text-dark"></li>
                    </ul>
                </div>
                <div class="d-flex align-items-center py-1">
                    <a class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#novo_trabalho">Novo Trabalho</a>
                </div>
            </div>
        </div>
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-xxl">
                <div class="card">
                    <div class="card-header border-0 pt-6">
                        <div class="card-title">
                            <div class="d-flex align-items-center position-relative my-1">
                                <span class="svg-icon svg-icon-1 position-absolute ms-6">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                        <rect opacity="0.5" x="17.0365" y="15.1223" width="8.15546" height="2" rx="1" transform="rotate(45 17.0365 15.1223)" fill="black" />
                                        <path d="M11 19C6.55556 19 3 15.4444 3 11C3 6.55556 6.55556 3 11 3C15.4444 3 19 6.55556 19 11C19 15.4444 15.4444 19 11 19ZM11 5C7.53333 5 5 7.53333 5 11C5 14.4667 7.53333 17 11 17C14.4667 17 17 14.4667 17 11C17 7.53333 14.4667 5 11 5Z" fill="black" />
                                    </svg>
                                </span>
                                <form action="{{ route('buscar') }}" method="post">
                                    @csrf
                                    <input type="text" name="s" class="form-control form-control-solid w-250px ps-14" placeholder="Busca rápida" />
                                </form>
                            </div>
                        </div>
                        <div class="card-toolbar">
                            <div class="d-flex justify-content-end align-items-center d-none" data-kt-user-table-toolbar="selected">
                                <div class="fw-bolder me-5">
                                    <span class="me-2" data-kt-user-table-select="selected_count"></span>Selected
                                </div>
                                <button type="button" class="btn btn-danger" data-kt-user-table-select="delete_selected">Delete Selected</button>
                            </div>
                        </div>
                    </div>
                    <div class="card-body pt-0">
                        <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_table_users">
                            <thead>
                                <tr class="text-start text-muted fw-bolder fs-7 text-uppercase gs-0">
                                    <th class="">Titulo</th>
                                    <th class="">Grau</th>
                                    <th class="">Abrir</th>
                                    <th class="text-end min-w-100px">Ações</th>
                                </tr>
                            </thead>
                            <tbody class="text-gray-600 fw-bold">
                                @foreach ($exe as $item)
                                    <tr>
                                        <td>{{ $item->titulo }}</td>
                                        <td>{{ $item->grau }}</td>
                                        <td>
                                            <a target="_blank" href="{{$item->ano == '2023' ? 'https://agendamaconicabrasil.com.br/midias/trabalhos-maconicos/'.$item->arquivo : url("storage/{$item->arquivo}") }}" class="btn btn-primary btn-active-primary btn-sm" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">
                                                Gerenciar
                                            </a>
                                        </td>
                                        <td class="text-end">
                                            <a href="{{ route('trabalho.destroy', $item->id) }}" class="btn btn-primary btn-active-primary btn-sm">
                                                Excluir
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="novo_trabalho" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered mw-650px">
                <div class="modal-content rounded">
                    <div class="modal-header pb-0 border-0 justify-content-end">
                        <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                            <span class="svg-icon svg-icon-1">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                    <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="black" />
                                    <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="black" />
                                </svg>
                            </span>
                        </div>
                    </div>
                    <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                        <form enctype="multipart/form-data" id="kt_modal_new_target_form" class="form" method="POST" action="{{ route('trabalho.store') }}">
                            @csrf
                            <div class="mb-13 text-center">
                                <h1 class="mb-3">Adicionar Trabalho Maçônico</h1>
                            </div>
                            <div class="d-flex flex-column mb-8 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold mb-2">
                                    <span class="required">Título</span>
                                </label>
                                <input type="text" name="titulo" id="titulo" class="form-control form-control-lg form-control-solid" placeholder="Título">
                            </div>
                            <div class="d-flex flex-column mb-8 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold mb-2">
                                    <span class="required">Anexo</span>
                                </label>
                                <input type="file" name="arquivo" class="form-control form-control-lg form-control-solid">
                            </div>
                            <div class="d-flex flex-column mb-8 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold mb-2">
                                    <span class="required">Grau</span>
                                </label>
                                <select name="grau" class="form-control form-control-lg form-control-solid">
                                    <option value="Aprendiz">Aprendiz</option>
                                    <option value="Companheiro">Companheiro</option>
                                    <option value="Mestre">Mestre</option>
                                </select>
                            </div>
                            <div class="text-center">
                                <button type="submit" name="executar" class="btn btn-primary" id="salvar">Salvar</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('css')
    <link rel="shortcut icon" href="{{ url('adm') }}/assets/media/logos/favicon.ico" />
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />
    <link href="{{ url('adm') }}/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
    <link href="{{ url('adm') }}/assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css" />
    <link href="{{ url('adm') }}/assets/css/style.bundle.css" rel="stylesheet" type="text/css" />
@endsection

@section('js')

    <script src="{{ url('adm') }}/assets/plugins/global/plugins.bundle.js"></script>
    <script src="{{ url('adm') }}/assets/js/scripts.bundle.js"></script>
    <!--begin::Page Vendors Javascript(used by this page)-->
    <script src="{{ url('adm') }}/assets/plugins/custom/datatables/datatables.bundle.js"></script>
    <!--end::Page Vendors Javascript-->
    <!--begin::Page Custom Javascript(used by this page)-->
    <script src="{{ url('adm') }}/assets/js/custom/apps/user-management/users/list/table.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/user-management/users/list/export-users.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/user-management/users/list/add.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/widgets.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/chat/chat.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/create-app.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/upgrade-plan.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/intro.js"></script>
    <!--end::Page Custom Javascript-->


    <script>
        @session('success')
        Swal.fire({
            text: "Trabalho foi cadastrado com sucesso",
            icon: "success",
            buttonsStyling: false,
            confirmButtonText: "Fechar",
            customClass: {
                confirmButton: "btn btn-primary"
            }
        });
        @session
        
    </script>

@endsection
