<!DOCTYPE html>
<html lang="zxx">
<head>
    <title>INVO - Invoice HTML5 Template</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta charset="UTF-8">

    <!-- External CSS libraries -->
    <link type="text/css" rel="stylesheet" href="{{ url('prints') }}/assets/css/bootstrap.min.css">
    <link type="text/css" rel="stylesheet" href="{{ url('prints') }}/assets/fonts/font-awesome/css/font-awesome.min.css">

    <!-- Favicon icon -->
    <link rel="shortcut icon" href="{{ url('prints') }}/assets/img/favicon.ico" type="image/x-icon" >

    <!-- Google fonts -->
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&amp;display=swap" rel="stylesheet">

    <!-- Custom Stylesheet -->
    <link type="text/css" rel="stylesheet" href="{{ url('prints') }}/assets/css/style.css">
</head>
<body>

<!-- Invoice 6 start -->
<div class="invoice-6 invoice-content">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="invoice-inner-6" id="invoice_wrapper">
                    <div class="invoice-top">
                        <div class="row">
                            <div class="col-sm-6">
                                <div>
                                    <img width="70" src="{{ url('adm') }}/assets/media/logos/logo.png" alt="logo">
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="invoice">
                                    <h1>Receita</h1>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="invoice-titel">
                        <div class="row">
                            <div class="invoice2 col-sm-6">
                                <h3>Receita# <span>1</span></h3>
                            </div>
                            <div class="date col-sm-6 text-end">
                                <h3>Data da emissão <span>12/09/21</span></h3>
                            </div>
                        </div>
                    </div>
                    <div class="invoice-info border-bottom">
                        <div class="row">
                            <div class="col-sm-6 mb-30">
                                <div class="invoice-number">
                                    <h4 class="inv-title-1">Animal</h4>
                                    <p class="invo-addr-1">
                                        Theme Vessel <br/>
                                        info@themevessel.com <br/>
                                        21-12 Green Street, Meherpur, Bangladesh <br/>
                                    </p>
                                </div>
                            </div>
                            <div class="col-sm-6 mb-30">
                                <div class="invoice-number text-end">
                                    <h4 class="inv-title-1">Clínica</h4>
                                    <p class="invo-addr-1">
                                        Apexo Inc  <br/>
                                        billing@apexo.com <br/>
                                        169 Teroghoria, Bangladesh <br/>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6 mb-30">
                                <h4 class="inv-title-1">Date</h4>
                                <p class="inv-from-1">Due Date:24/08/2021</p>
                            </div>
                            <div class="col-sm-6 text-end mb-30">
                                <h4 class="inv-title-1">Payment Method</h4>
                                <p class="inv-from-1">Credit Card</p>
                            </div>
                        </div>
                    </div>
                    <div class="order-summary">
                        <div class="table-responsive">
                            <table class="table invoice-table">
                                <thead class="bg-active">
                                <tr>
                                    <th>Item Item</th>
                                    <th class="text-center">Price</th>
                                    <th class="text-center">Quantity</th>
                                    <th class="text-right">Totals</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr>
                                    <td>
                                        <div class="item-desc-1">
                                            <span>BS-200</span>
                                            <small>Customize web application</small>
                                        </div>
                                    </td>
                                    <td class="text-center">$10.99</td>
                                    <td class="text-center">1</td>
                                    <td class="text-right">$10.99</td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="item-desc-1">
                                            <span>BS-201</span>
                                            <small>Website SEO improvement of themevessel.com Website development and customization for themevessel</small>
                                        </div>
                                    </td>
                                    <td class="text-center">$20.00</td>
                                    <td class="text-center">3</td>
                                    <td class="text-right">$60.00</td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="item-desc-1">
                                            <span>BS-200</span>
                                            <small>Customize web application</small>
                                        </div>
                                    </td>
                                    <td class="text-center">$10.99</td>
                                    <td class="text-center">1</td>
                                    <td class="text-right">$10.99</td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="item-desc-1">
                                            <span>BS-233</span>
                                            <small>Website SEO improvement of themevessel.com Website development and customization for themevessel</small>
                                        </div>
                                    </td>
                                    <td class="text-center">$640.00</td>
                                    <td class="text-center">1</td>
                                    <td class="text-right">$640.00</td>
                                </tr>
                                <tr>
                                    <td colspan="3" class="text-end">SubTotal</td>
                                    <td class="text-right">$710.99</td>
                                </tr>
                                <tr>
                                    <td colspan="3" class="text-end">Tax</td>
                                    <td class="text-right">$85.99</td>
                                </tr>
                                <tr>
                                    <td colspan="3" class="text-end fw-bold">Grand Total</td>
                                    <td class="text-right fw-bold">$795.99</td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="invoice-informeshon">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="payment-info">
                                    <h3 class="inv-title-1">Payment Info</h3>
                                    <ul class="bank-transfer-list-1">
                                        <li><strong>Account Name:</strong>Syamsuddin</li>
                                        <li><strong>Account Number:</strong>1234567890934</li>
                                        <li><strong>Code:</strong>BARC0032UK</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="terms-and-condistions text-end">
                                    <h3 class="inv-title-1">Terms and Condistions</h3>
                                    <p class="mb-0">Once order done, money can't refund. Delivery might delay due to some external dependency</p>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-4">
                            <div class="col-sm-12">
                                <h4 class="inv-title-1">Notes</h4>
                                <p class="text-muted">This is computer generated invoice and physical signature does not require.</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="invoice-btn-section clearfix d-print-none">
                    <a href="javascript:window.print()" class="btn btn-lg btn-print">
                        <i class="fa fa-print"></i> Print Invoice
                    </a>
                    <a id="invoice_download_btn" class="btn btn-lg btn-download">
                        <i class="fa fa-download"></i> Download Invoice
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Invoice 6 end -->

<script src="{{ url('prints') }}/assets/js/jquery.min.js"></script>
<script src="{{ url('prints') }}/assets/js/jspdf.min.js"></script>
<script src="{{ url('prints') }}/assets/js/html2canvas.js"></script>
<script src="{{ url('prints') }}/assets/js/app.js"></script>
</body>
</html>
