@extends('layouts.base')
@section('titulo', 'Perfil do Cliente')
@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="toolbar" id="kt_toolbar">
            <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
                <div data-kt-swapper="true" data-kt-swapper-mode="prepend"
                    data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}"
                    class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
                    <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">Meus dados</h1>
                    <span class="h-20px border-gray-200 border-start mx-4"></span>
                    <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                        <li class="breadcrumb-item text-muted">
                            <a href="{{ route('home') }}" class="text-muted text-hover-primary">Home</a>
                        </li>
                        <li class="breadcrumb-item"><span class="bullet bg-gray-200 w-5px h-2px"></span></li>
                        <li class="breadcrumb-item text-dark">{{ Auth::user()->name }}</li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-xxl">
                @if (session('message'))
                    <div class="alert alert-danger d-flex align-items-center p-5 mb-10">
                        <span class="svg-icon svg-icon-2hx svg-icon-danger me-4">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                <path opacity="0.3"
                                    d="M20.5543 4.37824L12.1798 2.02473C12.0626 1.99176 11.9376 1.99176 11.8203 2.02473L3.44572 4.37824C3.18118 4.45258 3 4.6807 3 4.93945V13.569C3 14.6914 3.48509 15.8404 4.4417 16.984C5.17231 17.8575 6.18314 18.7345 7.446 19.5909C9.56752 21.0295 11.6566 21.912 11.7445 21.9488C11.8258 21.9829 11.9129 22 12.0001 22C12.0872 22 12.1744 21.983 12.2557 21.9488C12.3435 21.912 14.4326 21.0295 16.5541 19.5909C17.8169 18.7345 18.8277 17.8575 19.5584 16.984C20.515 15.8404 21 14.6914 21 13.569V4.93945C21 4.6807 20.8189 4.45258 20.5543 4.37824Z"
                                    fill="black"></path>
                                <path
                                    d="M10.5606 11.3042L9.57283 10.3018C9.28174 10.0065 8.80522 10.0065 8.51412 10.3018C8.22897 10.5912 8.22897 11.0559 8.51412 11.3452L10.4182 13.2773C10.8099 13.6747 11.451 13.6747 11.8427 13.2773L15.4859 9.58051C15.771 9.29117 15.771 8.82648 15.4859 8.53714C15.1948 8.24176 14.7183 8.24176 14.4272 8.53714L11.7002 11.3042C11.3869 11.6221 10.874 11.6221 10.5606 11.3042Z"
                                    fill="black"></path>
                            </svg>
                        </span>
                        <div class="d-flex flex-column">
                            <h4 class="mb-1 text-danger">{{ session('message') }}</h4>
                        </div>
                    </div>
                @endif
                @if (session('success'))
                    <div class="alert alert-success d-flex align-items-center p-5 mb-10">
                        <span class="svg-icon svg-icon-2hx svg-icon-success me-4">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                <path opacity="0.3"
                                    d="M20.5543 4.37824L12.1798 2.02473C12.0626 1.99176 11.9376 1.99176 11.8203 2.02473L3.44572 4.37824C3.18118 4.45258 3 4.6807 3 4.93945V13.569C3 14.6914 3.48509 15.8404 4.4417 16.984C5.17231 17.8575 6.18314 18.7345 7.446 19.5909C9.56752 21.0295 11.6566 21.912 11.7445 21.9488C11.8258 21.9829 11.9129 22 12.0001 22C12.0872 22 12.1744 21.983 12.2557 21.9488C12.3435 21.912 14.4326 21.0295 16.5541 19.5909C17.8169 18.7345 18.8277 17.8575 19.5584 16.984C20.515 15.8404 21 14.6914 21 13.569V4.93945C21 4.6807 20.8189 4.45258 20.5543 4.37824Z"
                                    fill="black"></path>
                                <path
                                    d="M10.5606 11.3042L9.57283 10.3018C9.28174 10.0065 8.80522 10.0065 8.51412 10.3018C8.22897 10.5912 8.22897 11.0559 8.51412 11.3452L10.4182 13.2773C10.8099 13.6747 11.451 13.6747 11.8427 13.2773L15.4859 9.58051C15.771 9.29117 15.771 8.82648 15.4859 8.53714C15.1948 8.24176 14.7183 8.24176 14.4272 8.53714L11.7002 11.3042C11.3869 11.6221 10.874 11.6221 10.5606 11.3042Z"
                                    fill="black"></path>
                            </svg>
                        </span>
                        <div class="d-flex flex-column">
                            <h4 class="mb-1 text-success">{{ session('success') }}</h4>
                        </div>
                    </div>
                @endif

                @include('admin.perfil.base')

                <!--begin::CONTEÚDO DINÂMICO-->
                <div class="card">
                    <div class="card-header card-header-stretch">
                        <div class="card-title">
                            <h3 class="m-10 text-gray-800">Usuários</h3>
                        </div>
                    </div>
                    <div id="kt_referred_users_tab_content" class="tab-content">

                            <div class="table-responsive">
                                <table class="table table-flush align-middle table-row-bordered table-row-solid gy-4 gs-9">
                                    <thead class="border-gray-200 fs-5 fw-bold bg-lighten">
                                        <tr>
                                            <th class="min-w-175px ps-9">Nome</th>
                                            <th class="min-w-150px px-0">E-mail</th>
                                            <th class="min-w-350px">Permissões</th>
                                            <th class="min-w-125px text-center">Ações</th>
                                        </tr>
                                    </thead>

                                    <tbody class="fs-6 fw-bold text-gray-600">
                                        @foreach ($usuarios as $usuario)
                                            <tr>
                                                <td class="ps-9">{{$usuario->name}}</td>
                                                <td class="ps-0">{{$usuario->email}}</td>
                                                <td>
                                                    <div class="badge badge-light-{{$usuario->cliente == 1 ? 'success' : 'danger'}} fw-bolder">Clientes</div><br>
                                                    <div class="badge badge-light-{{$usuario->atendimento_veterinario == 1 ? 'success' : 'danger'}} fw-bolder">Atendimentos Veterinários</div><br>
                                                    <div class="badge badge-light-{{$usuario->atendimento_adestramento == 1 ? 'success' : 'danger'}} fw-bolder">Atendimentos Adestramentos</div><br>
                                                    <div class="badge badge-light-{{$usuario->atendimento_refeicoes == 1 ? 'success' : 'danger'}} fw-bolder">Atendimentos Refeições</div><br>
                                                    <div class="badge badge-light-{{$usuario->animais == 1 ? 'success' : 'danger'}} fw-bolder">Animais</div><br>
                                                    <div class="badge badge-light-{{$usuario->pdv == 1 ? 'success' : 'danger'}} fw-bolder">PDV</div><br>
                                                    <div class="badge badge-light-{{$usuario->financeiro == 1 ? 'success' : 'danger'}} fw-bolder">Financeiro</div><br>
                                                    <div class="badge badge-light-{{$usuario->relatorios == 1 ? 'success' : 'danger'}} fw-bolder">Relatórios</div><br>
                                                    <div class="badge badge-light-{{$usuario->agenda == 1 ? 'success' : 'danger'}} fw-bolder">Agendamentos</div><br>
                                                    <div class="badge badge-light-{{$usuario->usuario == 1 ? 'success' : 'danger'}} fw-bolder">Usuários</div><br>
                                                    <div class="badge badge-light-{{$usuario->controle == 1 ? 'success' : 'danger'}} fw-bolder">Setores de Cotroles</div><br>
                                                    <div class="badge badge-light-{{$usuario->produto == 1 ? 'success' : 'danger'}} fw-bolder">Produtos</div>
                                                </td>
                                                 <td class="text-center">
                                                    <a href="{{route('editar.dados.usuario',$usuario->id)}}" class="btn btn-{{$usuario->id == Auth::user()->id ? 'success' : 'primary'}} btn-sm btn-active-light-{{$usuario->id == Auth::user()->id ? 'success' : 'primary'}}">{{$usuario->id == Auth::user()->id ? 'Você' : 'Gerenciar'}}</a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('css')
    <link rel="shortcut icon" href="{{ url('adm') }}/assets/media/logos/favicon.ico" />
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />
    <link href="{{ url('adm') }}/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet"
        type="text/css" />
    <link href="{{ url('adm') }}/assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css" />
    <link href="{{ url('adm') }}/assets/css/style.bundle.css" rel="stylesheet" type="text/css" />
@endsection

@section('js')
    <script src="{{ url('adm') }}/assets/plugins/global/plugins.bundle.js"></script>
    <script src="{{ url('adm') }}/assets/js/scripts.bundle.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/account/settings/deactivate-account.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/two-factor-authentication.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/widgets.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/chat/chat.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/create-app.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/upgrade-plan.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/intro.js"></script>

    <script>
        Inputmask({
            "mask": "999.999.999-99"
        }).mask("#cpf");
        Inputmask({
            "mask": "99/99"
        }).mask("#aniv");
        Inputmask({
            "mask": "(99) 99999-9999"
        }).mask("#celular");
        Inputmask({
            "mask": "99999-999"
        }).mask("#cep");
        Inputmask({
            "mask": "[9][.][9][.][9][.][9][9][9]KG"
        }).mask("#peso");
        Inputmask({
            "mask": "99/99/9999"
        }).mask("#nascimento");
    </script>

    <script>
        $(document).ready(function() {

            document.getElementById('senha').value = '';

            $("#sendUpdate").on("click", function() {
                if ($("#senha").val() != "") {
                    if ($("#senha").val() != $("#senha2").val()) {
                        Swal.fire({
                            title: "ATENÇÃO",
                            text: "As senhas precisam ser iguais",
                            icon: "error",
                            buttonsStyling: false,
                            confirmButtonText: "Corrigir",
                            customClass: {
                                confirmButton: "btn btn-danger"
                            }
                        });
                    } else {
                        document.getElementById("UpdatePerfil").submit();
                    }
                } else {
                    document.getElementById("UpdatePerfil").submit();
                }
            });

            $("#cep").on("blur", function() {
                var numCep = $("#cep").val();
                var url = "https://viacep.com.br/ws/" + numCep + "/json";
                $.ajax({
                    url: url,
                    type: "get",
                    dataType: "json",
                    success: function(dados) {
                        console.log(dados);
                        $("#cep").val(dados.cep);
                        $("#endereco").val(dados.logradouro);
                        $("#bairro").val(dados.bairro);
                        $("#cidade").val(dados.localidade);
                        $("#estado").val(dados.uf);
                    }
                })
            });
            $("#self").on("change", function() {
                document.getElementById("formSelf").submit();
            });
            $("#especie").change(function() {
                const url = $("#personForm").attr("data-especie-url");
                especie = $(this).val();
                $.ajax({
                    url: url,
                    data: {
                        'especie': especie
                    },
                    success: function(data) {
                        $("#raca").html(data);
                    }
                });
            });
        });
    </script>
@endsection
