<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'empresa_id',
        'potencia_id',
        'loja_id',
        'loja_maconica',
        'carteira',
        'founder',
        'nivel',
        'status',
        'tratamento',
        'name',
        'cpf',
        'rg',
        'email',
        'cnpj',
        'empresa',
        'fantasia',
        'telefone',
        'celular',
        'cep',
        'endereco',
        'numero',
        'complemento',
        'bairro',
        'cidade',
        'estado',
        'foto',
        'vencimento',
        'plano_id',
        'mensalidade',
        'licencas',
        'periodo',
        'update_plano',
        'assinatura',
        'validado',
        'file_doc',
        'termo_de_uso',
        'fundador',
        'perfil',
        'password',
    ];

     /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function anuncio()
    {
        return $this->hasOne("App\Models\Anuncio",'cliente_id','id');
    }
    public function anuncios()
    {
        return $this->hasMany("App\Models\Anuncio",'cliente_id','id');
    }
    public function favorito(){
        return $this->hasOne("App\Models\Favorito",'anuncio_id','id');
    }
    public function loja(){
        return $this->hasOne("App\Models\Loja",'id','loja_id');
    }
}
