<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Potencia extends Model
{
    use HasFactory;
    protected $fillable = [
        'nome',
        'estadual',
        'telefone',
        'email',
        'site',
        'endereco',
        'numero',
        'complemento',
        'bairro',
        'cidade',
        'estado',
        'cep',
        'federal',
        'mestre',
        'adjunto',
        'fundacao',
        'rito',
        'url',
    ];

    public function lojas()
    {
        return $this->hasMany('App\Models\Loja','potencia_id','id');
    }
}
