<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Categoria extends Model
{
    use HasFactory;

    protected $fillable = ['level1','url_level1','ico','destaque','keywords'];

    public function anuncios()
    {
        return $this->hasMany("App\Models\Anuncio",'categoria_id','id');
    }

    public function level2()
    {
        return $this->hasMany("App\Models\SubCategoria",'categoria_id','id');
    }
}
