<?php

namespace App\Http\Controllers;
use Mail;
use Illuminate\Http\Request;

class ContatoController extends Controller
{
    public function store(Request $request){

        $this->validate($request,[
            'nome' => 'required',
            'email' => 'required|email',
            'celular' => 'required',
            'assunto' => 'required',
            'msg' => 'required',
        ]);

        Mail::send('envia-email-de-contato', [
            'nome' => $request->nome,
            'email' => $request->email,
            'celular' => $request->celular,
            'assunto' => $request->assunto,
            'msg' => $request->msg,
        ], function($mail) use($request){
            $mail->from($request->email, $request->nome);
            $mail->to('nao-responda@criacaodesiteemsalvador.com.br')->subject('Novo Contato do Aplicativo');
        });

        Mail::send('resposta-email-de-contato', [
            'nome' => $request->nome,
            'email' => $request->email,
            'celular' => $request->celular,
            'assunto' => $request->assunto,
            'msg' => $request->msg,
        ], function($mail) use($request){
            $mail->from($request->email, $request->nome);
            $mail->to($request->email)->subject(env('APP_EMPRESA'));
        });

        return redirect()->back()->with('flash_message','Mensagem enviada!');

    }
}
