<?php

namespace App\Http\Controllers;

use App\Models\Anuncio;
use App\Models\AnuncioPessoas;
use App\Models\AnuncioTelefone;
use App\Models\Contato;
use App\Models\level1;
use App\Models\level2;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use GuzzleHttp\Client;

class ChatBotController extends Controller
{
    public function aniversariantes()
    {

        $client = new Client();
        $hoje = date('Y-m-d');

        // Data daqui a 30 dias
        $semana = date('Y-m-d', strtotime("+0 days"));

        // Buscar pessoas cujo nascimento está entre o dia e mês atual e daqui a 30 dias
        $aniversariante = AnuncioPessoas::where(function ($query) use ($hoje, $semana) {
            $query->whereBetween(DB::raw("DATE_FORMAT(nascimento, '%m-%d')"), [
                date('m-d', strtotime($hoje)),
                date('m-d', strtotime($semana))
            ]);
        })->first();

        $data = [
            'nome'          => 'Roberto',
            'celular'       => '71988494034',
        ];

        // $data = [
        //     'nome'          => $aniversariante->nome,
        //     'celular'       => $aniversariante->Anuncio->Whatsapp->numero,
        // ];

        $webhookUrl = "https://backend.botconversa.com.br/api/v1/webhooks-automation/catch/117946/qK0XtGDxENIq/";
        $response = $client->request('POST', $webhookUrl, [
            'json' => $data,
            'headers' => [
                'Content-Type'  => 'application/json',
                'Accept'        => 'application/json',
            ],
        ]);

        dd($aniversariante);
    } 


    public function MarketingUpdate(Request $request){
        $exe = Anuncio::find($request->id);
        $exe->update(['marketing' => '1']);
    }


    public function Marketing2()
    {
        $client = new Client();
        $exe = Anuncio::where('marketing','0')->where('cidade','Salvador')->get();
        // dd($exe);
        return view('time',compact('exe'));
        // $data = [
        //     'nome'          => 'Roberto',
        //     'celular'       => '71988494034',
        //     'endereco'       => 'Estr. Min. Antônio Carlos Magalhães, 556 - Buraquinho, Lauro de Freitas - BA, 42710-400',
        // ];

        // if (empty($exe->Whatsapp->numero)) {
        //     $exe->update(['marketing' => '1']);
        //     return redirect()->route('time', $exe->id);
        // }

        // try {
        //     $data = [
        //         'nome'          => $exe->nome,
        //         'celular'       => $exe->Whatsapp->numero,
        //         'endereco'      => $exe->endereco . ', ' . $exe->numero . ', ' . $exe->bairro . ', ' . $exe->cidade . '-' . $exe->estado . ' CEP ' . $exe->cep,
        //     ];

        //     $webhookUrl = "https://backend.botconversa.com.br/api/v1/webhooks-automation/catch/117946/XwMXmXPS90Ov/";

        //     $response = $client->request('POST', $webhookUrl, [
        //         'json' => $data,
        //         'headers' => [
        //             'Content-Type'  => 'application/json',
        //             'Accept'        => 'application/json',
        //         ],
        //     ]);

        //     $exe->update(['marketing' => '1']);
        //     return redirect()->route('time', $exe->id);
        // } catch (\Exception $e) {
        //     $exe->update(['marketing' => '1']);
        //     return redirect()->route('time', $exe->id);
        // }
    }

    public function Marketing()
    {
        $client = new Client();
        $exe = AnuncioTelefone::where('marketing','0')->where('tipo','Whatsapp')->whereNotNull('numero')->first();

        // $data = [
        //     'celular'   => '7191143075',
        //     'nome'      => 'Ir.·. Antônio Carlos',
        //     'anuncio'      => $exe->Anuncio->id,
        // ];

        try {
            $data = [
                'celular'   => setUri2($exe->numero),
                'nome'      => $exe->Anuncio->titulo_ir.' '.$exe->Anuncio->nome,
                'anuncio'      => $exe->Anuncio->id,
            ];

            $webhookUrl = "https://new-backend.botconversa.com.br/api/v1/webhooks-automation/catch/134821/n2Jft1YUcnNO/";

            $response = $client->request('POST', $webhookUrl, [
                'json' => $data,
                'headers' => [
                    'Content-Type'  => 'application/json',
                    'Accept'        => 'application/json',
                ],
            ]);

            // dd(setUri2($exe->numero),$data);

            $exe->update(['marketing' => '1']);
            return redirect()->route('time', $exe->id);

        } catch (\Exception $e) {

            $exe->update(['marketing' => '1']);
            return redirect()->route('time', $exe->id);
        }
    }

    public function time($id)
    {
        $exe = Contato::find($id);
        $time = gerarCodigo(2);
        if ($time < 10 || $time > 30) {
            $time = rand(10, 30); // Garante que o valor fique entre 1 e 15
        }
        return view('time', ['exe' => $exe, 'time' => $time]);
    }


    
}
