<?php

namespace App\Http\Controllers\Aplicativo;

use App\Http\Controllers\Controller;
use App\Models\Anuncio;
use App\Models\Categoria;
use App\Models\Estado;
use App\Models\SubCategoria;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class FiltroController extends Controller
{
    public function filtros()
    {
        $estados = Anuncio::selectRaw('id, estado')->where('status','1')->orderBy('estado','ASC')->groupBy('estado')->get();
        $todas_categorias = Categoria::orderby('titulo','ASC')->get();
        return view('app.filtro',compact('estados','todas_categorias'));
    }

    public function getCidades(Request $request)
    {
        // dd($request->all());
        $estado = Estado::find($request->estado);
        $estados = Anuncio::selectRaw('id, estado')->where('status','1')->orderBy('estado','ASC')->groupBy('estado')->get();
        $cidades = Anuncio::selectRaw('id, cidade')->where('status','1')->where('cidade','!=',null)->where('estado','LIKE','%'.$estado->uf.'%')->orderBy('cidade','ASC')->groupBy('cidade')->get();
        return view('app.ajax.getCidades', compact('cidades','estados'),['estado'=>$estado]);
    }

    public function FiltroCategorias(Request $request)
    {
        $anuncio        = Anuncio::find($request->id);
        $estado         = Estado::where('uf',$anuncio->estado)->first();
        $cidade         = $anuncio->cidade;
        $estados        = Anuncio::selectRaw('id, estado')->where('status','1')->orderBy('estado','ASC')->groupBy('estado')->get();
        $cidades        = Anuncio::selectRaw('id, cidade')->where('status','1')->where('estado','LIKE','%'.$estado->uf.'%')->orderBy('cidade','ASC')->groupBy('cidade')->get();
        $categorias     = Anuncio::selectRaw('id, categoria_id')->where('status','1')->where('cidade','LIKE','%'.$anuncio->cidade.'%')->orderBy('categoria_id','ASC')->groupBy('categoria_id')->get();

        return view('app.ajax.getCategorias', compact('cidades','estados','categorias'),['estado'=>$estado,'cidade'=>$cidade]);
    }

    public function FiltroSubCat(Request $request)
    {
        // dd($request->all());
        $anuncio    = Anuncio::where('categoria_id',$request->id)->where('cidade',$request->cidade)->first();
        $estado     = Estado::where('uf',$request->estado)->first();
        // dd($estado);
        $cidade     = $request->cidade;
        $categoria  = Categoria::orderby('titulo','ASC')->find($request->id);

        $estados    = Anuncio::selectRaw('id, estado')->where('status','1')->orderBy('estado','ASC')->groupBy('estado')->get();
        $cidades    = Anuncio::selectRaw('id, cidade')->where('status','1')->where('estado','LIKE','%'.$estado->uf.'%')->orderBy('cidade','ASC')->groupBy('cidade')->get();
        $categorias = Anuncio::selectRaw('id, categoria_id')->where('status','1')->where('cidade','LIKE','%'.$request->cidade.'%')->orderBy('categoria_id','ASC')->groupBy('categoria_id')->get();
        $subs       = Anuncio::selectRaw('id, sub_categoria_id')->where('status','1')->where('categoria_id',$request->id)->where('sub_categoria_id','!=',null)->orderBy('sub_categoria_id','ASC')->groupBy('sub_categoria_id')->get();
        return view('app.ajax.getSubs', compact('cidades','estados','categorias','subs'),['estado'=>$estado,'cidade'=>$cidade,'categoria'=>$categoria]);
    }


    public function FiltroFull(Request $request)
    {
        // dd($request->all());
        $estado     = Estado::where('uf',$request->estado)->first();
        $cidade     = $request->cidade;
        $categoria  = Categoria::orderby('titulo','ASC')->find($request->categoria);
        $sub        = SubCategoria::orderby('titulo','ASC')->find($request->id);
        $estados    = Anuncio::selectRaw('id, estado')->where('status','1')->orderBy('estado','ASC')->groupBy('estado')->get();
        $cidades    = Anuncio::selectRaw('id, cidade')->where('status','1')->where('estado','LIKE','%'.$estado->uf.'%')->orderBy('cidade','ASC')->groupBy('cidade')->get();
        $categorias = Anuncio::selectRaw('id, categoria_id')->where('status','1')->where('cidade','LIKE','%'.$request->cidade.'%')->orderBy('categoria_id','ASC')->groupBy('categoria_id')->get();
        $subs       = Anuncio::selectRaw('id, sub_categoria_id')->where('status','1')->where('categoria_id','LIKE','%'.$request->categoria.'%')->orderBy('sub_categoria_id','ASC')->groupBy('sub_categoria_id')->get();
        // dd($estado->uf);
        return view('app.ajax.full', compact('cidades','estados','categorias','subs'),['estado'=>$estado,'cidade'=>$cidade,'categoria'=>$categoria,'sub'=>$sub]);
    }

    public function filtrar(Request $request)
    {
        $sql = Anuncio::query();
        if ($request->sub_categoria_id) {
            $sql->where('sub_categoria_id', $request->sub_categoria_id);
        }
        if ($request->categoria_id) {
            $sql->where('categoria_id', $request->categoria_id);
        }
        if ($request->cidade) {
            $sql->where('cidade', $request->cidade);
        }
        if ($request->estado) {
            $sql->where('estado', $request->estado);
        }
        $anuncios   = $sql->where('status', '1')->where('thumb', '!=', '')->orderby('empresa','ASC')->get();
        $free       = $sql->where('status', '1')->where('thumb', '=', '')->orderby('empresa','ASC')->get();
        $todas_categorias = Categoria::orderby('titulo','ASC')->get();
        return view('app.anuncios',compact('anuncios','todas_categorias','free'));
    }
}
