<?php

namespace App\Http\Controllers\Aplicativo;

use App\Http\Controllers\Controller;
use App\Models\Anuncio;
use App\Models\AnuncioTelefone;
use App\Models\Categoria;
use App\Models\Favorito;
use App\Models\SubCategoria;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class AppAnuncioController extends Controller
{
    public function anuncio($id)
    {
        $anuncio = Anuncio::with('telefones')->find($id);
        $todas_categorias = Categoria::orderby('level1', 'ASC')->get();

        $up['visitas'] = $anuncio['visitas'] + 1;
        $anuncio->update($up);


        $ico = [
            'Celular' => 'phone-portrait-outline',
            'Fixo' => 'call-outline',
            'Whatsapp' => 'logo-whatsapp',
            'WhatsApp' => 'logo-whatsapp',
        ];

        // dd($anuncio);
        return view('app.anuncio', compact('todas_categorias'), ['anuncio' => $anuncio, 'ico' => $ico]);
    }

    public function arte($contrato)
    {
        $anuncio = Anuncio::where('contrato',$contrato)->first();
        $todas_categorias = Categoria::orderby('level1', 'ASC')->get();

        $up['visitas'] = $anuncio['visitas'] + 1;
        $anuncio->update($up);


        $ico = [
            'Celular' => 'phone-portrait-outline',
            'Fixo' => 'call-outline',
            'Whatsapp' => 'logo-whatsapp',
            'WhatsApp' => 'logo-whatsapp',
        ];

        return view('app.arte', compact('todas_categorias'), ['anuncio' => $anuncio, 'ico' => $ico]);
    }

    public function AnunciosCategorias($id, $sub)
    {
        $sql = Anuncio::query();
        if ($sub > 0) {
            $sql->where('sub_categoria_id', $sub);
        }
        $categoria          = Categoria::find($id);
        $anuncios           = $sql->where('status', '1')->get();
        $todas_categorias   = Categoria::orderby('titulo', 'ASC')->get();
        return view('app.anuncios', compact('anuncios', 'todas_categorias'), ['categoria' => $categoria]);
    }

    public function anunciar()
    {
        $anuncio = Anuncio::where('user_id', Auth::user()->id)->where('status', '10')->first();
        if (!$anuncio) {
            $set['cliente_id'] = Auth::user()->id;
            $set['user_id'] = Auth::user()->id;
            $set['status']  = 10;
            Anuncio::create($set);
            $anuncio_id = DB::getPdo()->lastInsertId();
        } else {
            $anuncio_id = $anuncio->id;
        }
        return redirect()->route('app.editar.anuncio', $anuncio_id);
    }

    public function EditarAnuncio($id)
    {
        $anuncio = Anuncio::find($id);
        $categorias = Categoria::orderby('titulo', 'ASC')->where('titulo','!=','')->get();
        $telefones = AnuncioTelefone::where('anuncio_id', $id)->get();
        $active = 'index';
        // if(count($telefones) == 0){
        //     return redirect()->back()->with('Informe um telefone para continuar');
        // }
        return view('app.editar-anuncio', compact('categorias', 'telefones'), ['anuncio' => $anuncio,'active'=>$active]);
    }

    public function UpdateAnuncio(Request $request, $id)
    {
        // dd($request->all());
        $dados      = $request->all();
        $anuncio    = Anuncio::find($id);
        $categoria  = Categoria::find($request->categoria_id);
        $sub        = SubCategoria::find($request->sub_categoria_id);

        if ($request->thumb) {
            $nameFile       = Str::of($request->empresa)->slug('-') . rand() . '.' . $request->thumb->getClientOriginalExtension();
            $dados['thumb'] = $request->thumb->storeAs('anuncios', $nameFile);
        }else{
            $dados['thumb'] = '';
        }
        $dados['url']       = Str::of($request->empresa)->slug('-').rand();
        $dados['cliente_id'] = Auth::user()->id;
        $dados['status']    = 2;
        if(empty($categoria->titulo)){
            return redirect()->back()->with('error','Informa uma categoria para continuar');
        }
        $dados['level1']    = $categoria->titulo;
        // $dados['level2']    = $sub->titulo;
        $anuncio->update($dados);
        return redirect()->route('meu.perfil')->with('success','Anuncio em Análise');
    }

    public function AddFavorito(Request $request)
    {
        $favorito = Favorito::where('anuncio_id',$request->id)->where('user_id',Auth::user()->id)->first();
        if($favorito){

        }else{
            $dados['anuncio_id']    = $request->id;
            $dados['user_id']       = Auth::user()->id;
            Favorito::create($dados);
            $favorito = Favorito::where('anuncio_id',$request->id)->where('user_id',Auth::user()->id)->first();
            return view('app.ajax.favorito',['favorito'=>$favorito]);
        }
    }

    public function DellFavorito(Request $request)
    {
        $anuncio    = Anuncio::find($request->id);
        $favorito   = Favorito::where('anuncio_id',$request->id)->where('user_id',Auth::user()->id)->first();
        $favorito->delete();
        return view('app.ajax.favorito-dell',['anuncio'=>$anuncio]);
    }


    public function Ligar(Request $request)
    {
        $telefone    = AnuncioTelefone::find($request->id);
        $anuncio    = Anuncio::find($telefone->anuncio_id);
        if($telefone->tipo == 'Whatsapp'){
            $anuncio->update(["conversar"=>$anuncio->conversar+1]);
            return response()->json(['tipo' => 'ligar', 'numero' => tiraMoeda($telefone->numero)]);
        }else{
            $anuncio->update(["ligar"=>$anuncio->ligar+1]);
            return response()->json(['tipo' => 'ligar', 'numero' => $telefone->numero]);
        }

    }
}
