<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Categoria;
use App\Models\Servico;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class ServicoController extends Controller
{
     public function index()
     {
         $servicos = Servico::get();
         return view('admin.servicos.index',compact('servicos'));
     }
     public function create()
     {
         $categorias = Categoria::get();
         return view('admin.servicos.create',compact('categorias'));
     }

     public function store(Request $request)
     {

        $dados              = $request->all();
        $nameFile           = Str::of($request->titulo)->slug('-') . rand() . '.' . $request->image->getClientOriginalExtension();
        $dados['image']     = $request->image->storeAs('servicos', $nameFile);
        Servico::create($dados);
        return redirect()->back()->with('success', 'Serviço cadastrado com sucesso');
     }

     public function edit($id)
     {
         $servico = Servico::find($id);
         $categorias = Categoria::get();
         return view('admin.servicos.edit',compact('categorias'),['servico'=>$servico]);
     }

     public function update(Request $request, $id)
     {
        $servico = Servico::find($id);
        $dados              = $request->all();
        if($request->image){
            $nameFile           = Str::of($request->titulo)->slug('-') . rand() . '.' . $request->image->getClientOriginalExtension();
            $dados['image']     = $request->image->storeAs('servicos', $nameFile);
        }
        $servico->update($dados);
        return redirect()->back()->with('success', 'Serviço atualizado com sucesso');
     }

}
