<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Estado;
use App\Models\Potencia;
use App\Models\Rito;
use Illuminate\Http\Request;

class PotenciaController extends Controller
{

    public function index()
    {
        $potencias = Potencia::get();
        return view('admin.potencias.index', compact('potencias'));
    }


    public function create()
    {
        $ritos = Rito::get();
        $estados = Estado::get();
        return view('admin.potencias.create', compact('ritos','estados'));
    }


    public function store(Request $request)
    {
        Potencia::create($request->all());
        return redirect()->back()->with('success','Potência cadastrada com sucesso');
    }


    public function show($id)
    {
        $potencia = Potencia::find($id);
        $ritos = Rito::get();
        $estados = Estado::get();
        return view('admin.potencias.show',compact('ritos','estados'),['potencia'=>$potencia]);
    }

    public function update(Request $request, $id)
    {
        $potencia = Potencia::find($id);
        $potencia->update($request->all());
        return redirect()->back()->with('success','Potência atualizada com sucesso');
    }


    public function destroy($id)
    {
        $potencia = Potencia::find($id);
        $potencia->delete();
        return redirect()->route('potencias.index')->with('error','Potência deletada');
    }
}
