<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Estado;
use App\Models\Loja;
use App\Models\LojaTelefone;
use App\Models\Potencia;
use App\Models\Rito;
use Illuminate\Http\Request;

class LojaController extends Controller
{

    public function lojas($id)
    {
        $potencia = Potencia::find($id);
        $lojas = Loja::where('potencia', $id)->with('potencia')->get();
        return view('admin.potencias.lojas', compact('lojas'), ['potencia' => $potencia]);
    }


    public function index()
    {
        $lojas = [];
        return view('admin.lojas.index', compact('lojas'));
    }

    public function buscar(Request $request)
    {
        $lojas = Loja::where('loja','LIKE','%'.$request->s.'%')->get();
        // dd($lojas);
        return view('admin.lojas.index', compact('lojas'));
    }


    public function create()
    {
        $ritos      = Rito::get();
        $estados    = Estado::get();
        $potencias  = Potencia::get();
        // dd($ritos);
        return view('admin.lojas.create', compact('ritos', 'estados', 'potencias'));
    }

    public function store(Request $request)
    {
        $dados = $request->all();
        $estado = Estado::where('uf',$request->estado)->first();

        // dd($request->all(), $estado);
        $dados['estado'] = $estado->nome;
        Loja::create($dados);
        return redirect()->back()->with('success', 'Loja Cadastrada com sucesso');
    }


    public function show($id)
    {
        $loja = Loja::find($id);
        $ritos      = Rito::get();
        $estados    = Estado::get();
        $potencias  = Potencia::get();
        return view('admin.lojas.show', compact('ritos', 'estados', 'potencias'), ['loja' => $loja]);
    }


    public function update(Request $request, $id)
    {
        $estado = Estado::where('uf',$request->estado)->first();
        $dados = $request->all();
        $dados['estado'] = $estado->nome;

        $loja = Loja::find($id);
        $loja->update($dados);
        return redirect()->back()->with('success', 'Dados atualizados com sucesso');
    }


    public function destroy($id)
    {
        $loja = Loja::find($id);
        $loja->delete();
        return redirect()->route('lojas.index')->with('error', 'Potência deletada');
    }


    public function AddTelefone(Request $request)
    {
        $dados['lojaID']        = $request->id;
        $dados['tipo']          = $request->tipo;
        $dados['numero']        = tiraMoeda($request->numero);
        LojaTelefone::create($dados);
        $telefones      = LojaTelefone::where('lojaID', $request->id)->get();

        return view('admin.ajax.telefones', compact('telefones'));
    }

    public function RemoveTelefone(Request $request)
    {
        $exe        = LojaTelefone::find($request->id);
        $exe->delete();
    }
}
