<?php

function lmWord($string, $words = '400') {
    $string = strip_tags($string);
    $count = strlen($string);

    if ($count <= $words) {
        return $string;
    } else {
        $strpos = strrpos(substr($string, 0, $words), ' ');
        return substr($string, 0, $strpos);
    }
}

function setUri($string) {
    $a = 'ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜüÝÞßàáâãäåæçèéêëìíîïðñòóôõöøùúûýýþÿŔŕ"!@#$%&*()_-+={[}]/?;:.,\\\'<>°ºª';
    $b = 'aaaaaaaceeeeiiiidnoooooouuuuuybsaaaaaaaceeeeiiiidnoooooouuuyybyRr                                 ';
    $string = utf8_decode($string);
    $string = strtr($string, utf8_decode($a), $b);
    $string = strip_tags(trim($string));
    $string = str_replace(" ", "-", $string);
    $string = str_replace(array("-----", "----", "---", "--"), "-", $string);
    return strtolower(utf8_encode($string));
}
function setUri2($string) {
    $a = 'ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜüÝÞßàáâãäåæçèéêëìíîïðñòóôõöøùúûýýþÿŔŕ"!@#$%&*()_-+={[}]/?;:.,\\\'<>°ºª';
    $b = 'aaaaaaaceeeeiiiidnoooooouuuuuybsaaaaaaaceeeeiiiidnoooooouuuyybyRr                                 ';
    $string = utf8_decode($string);
    $string = strtr($string, utf8_decode($a), $b);
    $string = strip_tags(trim($string));
    $string = str_replace(" ", "", $string);
    $string = str_replace(array("-----", "----", "---", "--"), "", $string);
    return strtolower(utf8_encode($string));
}

function tiraMoeda($valor)
{
    $novoValor = preg_replace("/[^0-9\s]/", "", $valor);
    return $novoValor;
}

function moeda($valor) {
    $valor = number_format($valor / 100, 2, ",", ".");
    str_replace(',', '%', $valor);
    str_replace('.', ',', $valor);
    return str_replace('%', '.', $valor);
}

function formatCnpjCpf($value) {
    $CPF_LENGTH = 11;
    $cnpj_cpf = preg_replace("/\D/", '', $value);
    if (strlen($cnpj_cpf) === $CPF_LENGTH) {
        return preg_replace("/(\d{3})(\d{3})(\d{3})(\d{2})/", "\$1.\$2.\$3-\$4", $cnpj_cpf);
    }
    return preg_replace("/(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/", "\$1.\$2.\$3/\$4-\$5", $cnpj_cpf);
}

function DiferencaPorcentagem($v1, $v2) {
    $perguntas = $v1;
    $acertos = $v2;
    return ((($perguntas - $acertos) / $perguntas) * 100);
}

function gerarCodigo($qtd) {
    $senha = "123456789";
//    $senha = "0123456789abcdefghijlmnopqrstuvxz";
    srand((double) microtime() * 1000000);
    $cod = false;
    for ($i = 0; $i < $qtd; $i++):
        $cod .= $senha[rand() % strlen($senha)];
    endfor;
    return $cod;
}

function porcentagem ($pctm, $total) {
    $valor_descontado = $total - ($total / 100 * $pctm);
    return  $total - $valor_descontado;
}

function formataTelefone($numero) {
    if (strlen($numero) == 10) {
        $novo = substr_replace($numero, '(', 0, 0);
        $novo = substr_replace($novo, '9', 3, 0);
        $novo = substr_replace($novo, ')', 3, 0);
    } else {
        $novo = substr_replace($numero, '(', 0, 0);
        $novo = substr_replace($novo, ')', 3, 0);
    }
    return $novo;
}

function formatarData($data) {
    // Verifica se a string possui a quantidade correta de caracteres (8)
    if (strlen($data) === 8) {
        // Extrai o dia, mês e ano da string
        $dia = substr($data, 0, 2);
        $mes = substr($data, 2, 2);
        $ano = substr($data, 4, 4);

        // Formata a data no formato desejado (dd/mm/yyyy)
        return "$dia/$mes/$ano";
    } else {
        // Se a string não tiver 8 caracteres, retorna um erro ou a própria string
        return "Formato de data inválido";
    }
}

function formatarCPF($cpf) {
    // Remove qualquer caractere não numérico
    $cpf = preg_replace('/\D/', '', $cpf);

    // Verifica se o CPF possui a quantidade correta de dígitos (11)
    if (strlen($cpf) === 11) {
        // Formata o CPF no padrão xxx.xxx.xxx-xx
        return substr($cpf, 0, 3) . '.' . substr($cpf, 3, 3) . '.' . substr($cpf, 6, 3) . '-' . substr($cpf, 9, 2);
    } else {
        // Se o CPF não tiver 11 dígitos, retorna um erro ou o próprio CPF
        return "Formato de CPF inválido";
    }
}

function formatarCNPJ($cnpj) {
    // Remove qualquer caractere não numérico
    $cnpj = preg_replace('/\D/', '', $cnpj);

    // Verifica se o CNPJ possui a quantidade correta de dígitos (14)
    if (strlen($cnpj) === 14) {
        // Formata o CNPJ no padrão xx.xxx.xxx/xxxx-xx
        return substr($cnpj, 0, 2) . '.' . substr($cnpj, 2, 3) . '.' . substr($cnpj, 5, 3) . '/' . substr($cnpj, 8, 4) . '-' . substr($cnpj, 12, 2);
    } else {
        // Se o CNPJ não tiver 14 dígitos, retorna um erro ou o próprio CNPJ
        return "Formato de CNPJ inválido";
    }
}


